package com.yunyinsign.api.sdk.core;

import com.alibaba.fastjson.annotation.JSONField;
import com.yunyinsign.api.sdk.BaseObject;
/**
 * 所有API请求的基类
 * @author dyl
 */
public abstract class BaseRequest<R extends BaseResponse> extends BaseObject {
    @JSONField(serialize = false)
    private Long headerUserId;
    @JSONField(serialize = false)
    private String headerSource;

    public Long getHeaderUserId() { return headerUserId; }
    public void setHeaderUserId(Long headerUserId) { this.headerUserId = headerUserId; }

    public String getHeaderSource() {
        return headerSource;
    }

    public void setHeaderSource(String headerSource) {
        this.headerSource = headerSource;
    }

    /**
     * 获取API路径
     */
    public abstract String getApiPath();

    /**
     * 获取HTTP方法
     */
    public abstract String getHttpMethod();

    /**
     * 获取响应类型引用
     */
    public abstract Class<R> getResponseType();
}
