package com.yunyinsign.api.sdk.core;

import com.alibaba.fastjson.annotation.JSONField;

import java.util.List;

/**
 * @author Fadada
 * 2021/9/11 15:31:15
 */
public class BasePageResponse extends BaseResponse {
    /**
     * 查询结果分页返回，此处指定第几页，如果不传默从第一页返回。页码从1开始，即首页为1
     */
    @JSONField(name = "listPageNo")
    private Integer listPageNo;
    /**
     * 当前返回页中的记录数量
     */
    @JSONField(name = "countInPage")
    private Integer countInPage;
    /**
     * 列表总分页数
     */
    @JSONField(name = "listPageCount")
    private Integer listPageCount;
    /**
     * 总记录数
     */
    @JSONField(name = "totalCount")
    private Integer totalCount;


    /**
     * 是否有下一页
     */
    public boolean hasNext() {
        return listPageNo < listPageCount;
    }

    /**
     * 是否有上一页
     */
    public boolean hasPrev() {
        return listPageNo > 1;
    }

    public Integer getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public Integer getListPageCount() {
        return listPageCount;
    }

    public void setListPageCount(Integer listPageCount) {
        this.listPageCount = listPageCount;
    }

    public Integer getListPageNo() {
        return listPageNo;
    }

    public void setListPageNo(Integer listPageNo) {
        this.listPageNo = listPageNo;
    }

    public Integer getCountInPage() {
        return countInPage;
    }

    public void setCountInPage(Integer countInPage) {
        this.countInPage = countInPage;
    }
}
