package com.yunyinsign.api.sdk.core;

import com.yunyinsign.api.sdk.internal.mapping.RequestField;

/**
 * 所有API请求的基类
 * @author dyl
 */
public abstract class BasePageRequest<R extends BasePageResponse> extends BaseRequest<R> {

    @RequestField(value = "页码")
    private Integer listPageNo;
    @RequestField(value = "每页数量")
    private Integer listPageSize;

    public Integer getListPageNo() {
        return listPageNo;
    }

    public void setListPageNo(Integer listPageNo) {
        if (listPageNo != null && listPageNo > 0) {
            this.listPageNo = listPageNo;
        }
    }

    public Integer getListPageSize() {
        return listPageSize;
    }

    public void setListPageSize(Integer listPageSize) {
        if (listPageSize != null && listPageSize > 0 && listPageSize <= 1000) {
            this.listPageSize = listPageSize;
        }
    }

}
