package com.yunyinsign.api.sdk.core;

import com.alibaba.fastjson.annotation.JSONField;
import com.yunyinsign.api.sdk.constants.RequestConstants;

import java.util.List;

/**
 * 所有API请求的基类
 * @author dyl
 */
public abstract class BaseListRequest<T,R extends BaseResponse> extends BaseRequest<R> {
    /**
     * 列表数据，会被序列化为JSON数组
     * 不参与默认的JSON序列化
      */
    @JSONField(serialize = false)
    private List<T> listData;

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取列表数据（用于序列化）
     */
    public List<T> getListData() {
        return listData;
    }

    /**
     * 设置列表数据
     */
    public void setListData(List<T> listData) {
        this.listData = listData;
    }

    /**
     * 自定义序列化方法：返回列表数据的JSON数组
     */
    public String toJson() {
        if (listData == null || listData.isEmpty()) {
            return "[]";
        }
        return com.alibaba.fastjson.JSON.toJSONString(listData);
    }

    /**
     * 创建列表请求的Builder
     */
    public static class Builder<T,R extends BaseResponse> {
        private final R request;
        private List<T> listData;

        public Builder(R request) {
            this.request = request;
        }

        public Builder<T, R> withListData(List<T> listData) {
            this.listData = listData;
            return this;
        }

    }

}
