package com.yunyinsign.api.sdk.core;

import com.alibaba.fastjson.annotation.JSONField;
import com.yunyinsign.api.sdk.constants.RequestConstants;

import java.util.HashMap;
import java.util.Map;

/**
 * @author dyl
 */
public abstract class BaseFileUploadRequest<R extends BaseResponse> extends BaseRequest<R> {
    @JSONField(serialize = false)
    private byte[] fileBytes;

    @JSONField(serialize = false)
    private String fileName;

    @JSONField(serialize = false)
    private String fieldName = "file";


    @JSONField(serialize = false)
    private Map<String, String> formParams = new HashMap<>();

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 添加额外的表单参数
     */
    public void addFormParam(String key, String value) {
        if (key != null && value != null) {
            formParams.put(key, value);
        }
    }

    /**
     * 获取额外的表单参数
     */
    public Map<String, String> getFormParams() {
        return formParams;
    }

    public byte[] getFileBytes() { return fileBytes; }
    public void setFileBytes(byte[] fileBytes) { this.fileBytes = fileBytes; }

    public String getFileName() { return fileName; }
    public void setFileName(String fileName) { this.fileName = fileName; }

    public String getFieldName() { return fieldName; }
    public void setFieldName(String fieldName) { this.fieldName = fieldName; }

    public void setFormParams(Map<String, String> formParams) { this.formParams = formParams; }

}
