package com.yunyinsign.api.demo;

import com.alibaba.fastjson.JSON;
import com.yunyinsign.api.sdk.client.YunYinClient;
import com.yunyinsign.api.sdk.model.vo.GetTemplateContractFileReq;
import com.yunyinsign.api.sdk.model.vo.GetTemplateParticipantReq;
import com.yunyinsign.api.sdk.model.vo.TemplateCompSpecialAttrReq;
import com.yunyinsign.api.sdk.model.vo.TemplateComponentReq;
import com.yunyinsign.api.sdk.request.template.GetTemplateDelReq;
import com.yunyinsign.api.sdk.request.template.GetTemplateEditeUrlReq;
import com.yunyinsign.api.sdk.request.template.GetTemplateManageUrlReq;
import com.yunyinsign.api.sdk.request.template.GetTemplateQueryReq;
import com.yunyinsign.api.sdk.request.template.GetTemplateSettingUrlReq;
import com.yunyinsign.api.sdk.request.template.GetTemplateUpdateStatusReq;
import com.yunyinsign.api.sdk.request.template.TemplateComponentCreateReq;
import com.yunyinsign.api.sdk.request.template.TemplateComponentModifyReq;
import com.yunyinsign.api.sdk.request.template.TemplateCreateReq;
import com.yunyinsign.api.sdk.request.template.TemplateIdReq;
import com.yunyinsign.api.sdk.request.template.TemplateInfoQueryReq;
import com.yunyinsign.api.sdk.request.template.TemplateModifyReq;
import com.yunyinsign.api.sdk.request.template.UploadAttachmentFileReq;
import com.yunyinsign.api.sdk.request.template.UploadContractFileReq;
import com.yunyinsign.api.sdk.response.template.GetTemplateEditeUrlResponse;
import com.yunyinsign.api.sdk.response.template.GetTemplateManageUrlResponse;
import com.yunyinsign.api.sdk.response.template.GetTemplateQueryResponse;
import com.yunyinsign.api.sdk.response.template.GetTemplateSettingUrlResponse;
import com.yunyinsign.api.sdk.response.template.TemplateComponentCreateResponse;
import com.yunyinsign.api.sdk.response.template.TemplateCreateResponse;
import com.yunyinsign.api.sdk.response.template.TemplateIdResponse;
import com.yunyinsign.api.sdk.response.template.TemplateInfoQueryResponse;
import com.yunyinsign.api.sdk.response.template.TemplateModifyResponse;
import com.yunyinsign.api.sdk.response.template.UploadAttachmentFileResponse;
import com.yunyinsign.api.sdk.response.template.UploadContractFileResponse;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author dyl
 * 模板管理相关接口
 */
public class TemplateApi {

    public static void main(String[] args) {
        // 1. 初始化客户端
        YunYinClient client = ClientConfig.initClient();
        TemplateApi templateApi = new TemplateApi();

        //上传模板合同文件
        templateApi.uploadContractFileReq(client);

        //上传模板附件文件
        templateApi.uploadAttachmentFileReq(client);

        //新增模板
        templateApi.templateCreateReq(client);

        //更新模板详情
        templateApi.templateModifyReq(client);

        //保存新增模板控件设置
        templateApi.templateComponentCreateReq(client);

        //保存编辑模板控件设置
        templateApi.templateComponentModifyReq(client);

        //查询模板控件信息
        templateApi.getTemplateComponentQueryReq(client);

        //模板列表查询
        templateApi.getTemplateListQueryReq(client);

        //模板详情查询
        templateApi.getTemplateInfoQueryReq(client);

        //启用/停用模板
        templateApi.getTemplateUpdateStatusReq(client);

        //模板删除
        templateApi.getTemplateDelReq(client);

        //获取模板管理链接
        templateApi.getTemplateManageUrlReq(client);

        //获取模板设置链接
        templateApi.getTemplateSettingUrlReq(client);

        //获取模板编辑链接
        templateApi.getTemplateEditUrlReq(client);
    }

    //上传模板合同文件
    private void uploadContractFileReq(YunYinClient client) {
        byte[] contractFileBytes = new byte[0];
        UploadContractFileReq uploadContractFileReq = UploadContractFileReq.create(contractFileBytes, "test.pdf");
        uploadContractFileReq.setHeaderUserId(000000000L);
        UploadContractFileResponse uploadContractFileResponse = client.execute(uploadContractFileReq);
        System.out.println(JSON.toJSONString(uploadContractFileResponse.getData()));
    }

    //上传模板附件文件
    private void uploadAttachmentFileReq(YunYinClient client) {
        byte[] attachmentFileBytes = new byte[0];
        UploadAttachmentFileReq uploadAttachmentFileReq = UploadAttachmentFileReq.create(attachmentFileBytes, "test.pdf");
        uploadAttachmentFileReq.setHeaderUserId(000000000L);
        UploadAttachmentFileResponse uploadAttachmentFileResponse = client.execute(uploadAttachmentFileReq);
        System.out.println(JSON.toJSONString(uploadAttachmentFileResponse.getData()));
    }

    //新增模板
    private void templateCreateReq(YunYinClient client) {
        TemplateCreateReq templateCreateReq = new TemplateCreateReq();
        templateCreateReq.setHeaderUserId(000000000L);
        templateCreateReq.setTemplateName("测试模板");
        List<GetTemplateParticipantReq> participantList = new ArrayList<>();
        GetTemplateParticipantReq participantReq = new GetTemplateParticipantReq();
        participantReq.setParticipantFlag("参与方1");
        participantReq.setParticipantType(1);
        participantReq.setParticipateBizType(Arrays.asList("1", "2"));
        participantReq.setParticipantSetMode(3);
        participantReq.setPsnAccount("00000000000000000000000000000000");
        participantReq.setPsnName("00000000000000000000000000000000");
        participantReq.setDraftSort(1);
        participantReq.setSignOrder(1);
        participantReq.setParticipantCorpName("测试企业");
        GetTemplateParticipantReq participantReq1 = new GetTemplateParticipantReq();
        participantReq1.setParticipantFlag("参与方2");
        participantReq1.setParticipantType(0);
        participantReq1.setParticipateBizType(Arrays.asList("1", "2"));
        participantReq1.setParticipantSetMode(0);
        participantReq1.setDraftSort(2);
        participantReq1.setSignOrder(2);
        participantReq1.setParticipantCorpName("测试企业");
        participantList.add(participantReq);
        participantList.add(participantReq1);
        templateCreateReq.setParticipantList(participantList);
        List<GetTemplateContractFileReq> contractFileList = new ArrayList<>();
        GetTemplateContractFileReq contractFileReq = new GetTemplateContractFileReq();
        contractFileReq.setFileName("测试合同1.pdf");
        contractFileReq.setFileUrl("https://openapi.yunyinsign.com/api/v1/template/contractFile/download?fileId=xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
        contractFileReq.setTotalPage(1);
        contractFileReq.setWidth(1);
        contractFileReq.setHeight(1);
        contractFileList.add(contractFileReq);
        templateCreateReq.setContractFileList(contractFileList);
        TemplateCreateResponse templateCreateResponse = client.execute(templateCreateReq);
        System.out.println(JSON.toJSONString(templateCreateResponse.getData()));
    }

    //更新模板详情
    private void templateModifyReq(YunYinClient client) {
        TemplateModifyReq templateModifyReq = new TemplateModifyReq();
        templateModifyReq.setHeaderUserId(000000000L);
        templateModifyReq.setTemplateId(00000000000000000000000000000000L);
        templateModifyReq.setTemplateName("测试模板");
        List<GetTemplateParticipantReq> modifyParticipantList = new ArrayList<>();
        GetTemplateParticipantReq modifyParticipantReq = new GetTemplateParticipantReq();
        modifyParticipantReq.setParticipantFlag("参与方1");
        modifyParticipantReq.setParticipantType(1);
        modifyParticipantReq.setParticipateBizType(Arrays.asList("1", "2"));
        modifyParticipantReq.setParticipantSetMode(3);
        modifyParticipantReq.setPsnAccount("00000000000000000000000000000000");
        modifyParticipantReq.setPsnName("00000000000000000000000000000000");
        modifyParticipantReq.setDraftSort(1);
        modifyParticipantReq.setSignOrder(1);
        modifyParticipantReq.setParticipantCorpName("测试企业");
        GetTemplateParticipantReq modifyParticipantReq1 = new GetTemplateParticipantReq();
        modifyParticipantReq1.setParticipantFlag("参与方2");
        modifyParticipantReq1.setParticipantType(0);
        modifyParticipantReq1.setParticipateBizType(Arrays.asList("1", "2"));
        modifyParticipantReq1.setParticipantSetMode(0);
        modifyParticipantReq1.setDraftSort(2);
        modifyParticipantReq1.setSignOrder(2);
        modifyParticipantReq1.setParticipantCorpName("测试企业");
        modifyParticipantList.add(modifyParticipantReq);
        modifyParticipantList.add(modifyParticipantReq1);
        templateModifyReq.setParticipantList(modifyParticipantList);
        List<GetTemplateContractFileReq> modifyContractFileList = new ArrayList<>();
        GetTemplateContractFileReq modifyContractFileReq = new GetTemplateContractFileReq();
        modifyContractFileReq.setFileName("测试合同1.pdf");
        modifyContractFileReq.setFileUrl("https://openapi.yunyinsign.com/api/v1/template/contractFile/download?fileId=xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
        modifyContractFileReq.setTotalPage(1);
        modifyContractFileReq.setWidth(1);
        modifyContractFileReq.setHeight(1);
        modifyContractFileList.add(modifyContractFileReq);
        templateModifyReq.setContractFileList(modifyContractFileList);
        TemplateModifyResponse templateModifyResponse = client.execute(templateModifyReq);
        System.out.println(JSON.toJSONString(templateModifyResponse.getData()));
    }

    //保存新增模板控件设置
    private void templateComponentCreateReq(YunYinClient client) {
        TemplateComponentCreateReq templateComponentCreateReq = new TemplateComponentCreateReq();
        templateComponentCreateReq.setHeaderUserId(000000000L);
        templateComponentCreateReq.setTemplateId(00000000000000000000000000000000L);
        List<TemplateComponentReq> componentList = new ArrayList<>();
        TemplateComponentReq componentReq = new TemplateComponentReq();
        componentReq.setParticipantId(3002L);
        componentReq.setContractFileId(2001L);
        componentReq.setComponentName("测试控件1");
        componentReq.setComponentType(1);
        componentReq.setRequired(1);
        componentReq.setPositionX(BigDecimal.valueOf(100.5));
        componentReq.setPositionY(BigDecimal.valueOf(200));
        componentReq.setPageNum(1);
        TemplateCompSpecialAttrReq specialAttribute = new TemplateCompSpecialAttrReq();
        specialAttribute.setMaxLength("10");
        specialAttribute.setFont("SimSun");
        specialAttribute.setFontSize(12);
        componentReq.setSpecialAttribute(specialAttribute);
        componentList.add(componentReq);
        templateComponentCreateReq.setComponents(componentList);
        TemplateComponentCreateResponse templateComponentCreateResponse = client.execute(templateComponentCreateReq);
        System.out.println(JSON.toJSONString(templateComponentCreateResponse.getData()));
    }

    //保存编辑模板控件设置
    private void templateComponentModifyReq(YunYinClient client) {
        TemplateComponentModifyReq templateComponentModifyReq = new TemplateComponentModifyReq();
        templateComponentModifyReq.setHeaderUserId(000000000L);
        templateComponentModifyReq.setTemplateId(00000000000000000000000000000000L);
        List<TemplateComponentReq> componentModifyList = new ArrayList<>();
        TemplateComponentReq componentModifyReq = new TemplateComponentReq();
        componentModifyReq.setParticipantId(3002L);
        componentModifyReq.setContractFileId(2001L);
        componentModifyReq.setComponentName("测试控件1");
        componentModifyReq.setComponentType(1);
        componentModifyReq.setRequired(1);
        componentModifyReq.setPositionX(BigDecimal.valueOf(100.5));
        componentModifyReq.setPositionY(BigDecimal.valueOf(200));
        componentModifyReq.setPageNum(1);
        TemplateCompSpecialAttrReq specialModifyAttribute = new TemplateCompSpecialAttrReq();
        specialModifyAttribute.setMaxLength("10");
        specialModifyAttribute.setFont("SimSun");
        specialModifyAttribute.setFontSize(12);
        componentModifyReq.setSpecialAttribute(specialModifyAttribute);
        componentModifyList.add(componentModifyReq);
        templateComponentModifyReq.setComponents(componentModifyList);
        client.execute(templateComponentModifyReq);
    }

    //查询模板控件信息
    private void getTemplateComponentQueryReq(YunYinClient client) {
        TemplateIdReq templateIdReq = new TemplateIdReq();
        templateIdReq.setHeaderUserId(000000000L);
        templateIdReq.setTemplateId(00000000000000000000000000000000L);
        TemplateIdResponse templateIdResponse = client.execute(templateIdReq);
        System.out.println(JSON.toJSONString(templateIdResponse.getData()));
    }

    //模板列表查询
    private void getTemplateListQueryReq(YunYinClient client) {
        GetTemplateQueryReq getTemplateQueryReq = new GetTemplateQueryReq();
        getTemplateQueryReq.setHeaderUserId(000000000L);
        getTemplateQueryReq.setListPageNo(1);
        getTemplateQueryReq.setListPageSize(10);
        getTemplateQueryReq.setTemplateStatus(1);
        GetTemplateQueryResponse getTemplateQueryResponse = client.execute(getTemplateQueryReq);
        System.out.println(JSON.toJSONString(getTemplateQueryResponse.getData()));
    }

    //模板详情查询
    private void getTemplateInfoQueryReq(YunYinClient client) {
        TemplateInfoQueryReq templateInfoQueryReq = new TemplateInfoQueryReq();
        templateInfoQueryReq.setHeaderUserId(000000000L);
        templateInfoQueryReq.setTemplateId(00000000000000000000000000000000L);
        templateInfoQueryReq.setTemplateType("2");
        TemplateInfoQueryResponse templateInfoQueryResponse = client.execute(templateInfoQueryReq);
        System.out.println(JSON.toJSONString(templateInfoQueryResponse.getData()));
    }

    //启用/停用模板
    private void getTemplateUpdateStatusReq(YunYinClient client) {
        GetTemplateUpdateStatusReq templateStatusModifyReq = new GetTemplateUpdateStatusReq();
        templateStatusModifyReq.setHeaderUserId(000000000L);
        templateStatusModifyReq.setTemplateId(00000000000000000000000000000000L);
        templateStatusModifyReq.setTemplateStatus(1);
        client.execute(templateStatusModifyReq);
    }

    //模板删除
    private void getTemplateDelReq(YunYinClient client) {
        GetTemplateDelReq templateDeleteReq = new GetTemplateDelReq();
        templateDeleteReq.setHeaderUserId(000000000L);
        templateDeleteReq.setTemplateId(00000000000000000000000000000000L);
        client.execute(templateDeleteReq);
    }

    //获取模板管理链接
    private void getTemplateManageUrlReq(YunYinClient client) {
        GetTemplateManageUrlReq getTemplateManageUrlReq = new GetTemplateManageUrlReq();
        getTemplateManageUrlReq.setHeaderUserId(000000000L);
        GetTemplateManageUrlResponse getTemplateManageUrlResponse = client.execute(getTemplateManageUrlReq);
        System.out.println(JSON.toJSONString(getTemplateManageUrlResponse.getData()));
    }

    //获取模板设置链接
    private void getTemplateSettingUrlReq(YunYinClient client) {
        GetTemplateSettingUrlReq getTemplateSettingUrlReq = new GetTemplateSettingUrlReq();
        getTemplateSettingUrlReq.setHeaderUserId(000000000L);
        getTemplateSettingUrlReq.setTemplateId(00000000000000000000000000000000L);
        GetTemplateSettingUrlResponse getTemplateSettingUrlResponse = client.execute(getTemplateSettingUrlReq);
        System.out.println(JSON.toJSONString(getTemplateSettingUrlResponse.getData()));
    }

    //获取模板编辑链接
    private void getTemplateEditUrlReq(YunYinClient client) {
        GetTemplateEditeUrlReq getTemplateEditUrlReq = new GetTemplateEditeUrlReq();
        getTemplateEditUrlReq.setHeaderUserId(000000000L);
        getTemplateEditUrlReq.setTemplateId(00000000000000000000000000000000L);
        GetTemplateEditeUrlResponse getTemplateEditUrlResponse = client.execute(getTemplateEditUrlReq);
        System.out.println(JSON.toJSONString(getTemplateEditUrlResponse.getData()));

    }

}
