package com.yunyinsign.api.demo;

import com.alibaba.fastjson.JSON;
import com.yunyinsign.api.sdk.client.YunYinClient;
import com.yunyinsign.api.sdk.core.DownloadResponse;
import com.yunyinsign.api.sdk.model.dto.FillComponentCmd;
import com.yunyinsign.api.sdk.model.dto.SignComponentCmd;
import com.yunyinsign.api.sdk.model.vo.GetStartSignFlowParticipantReq;
import com.yunyinsign.api.sdk.model.vo.GetTemplateComponentReq;
import com.yunyinsign.api.sdk.model.vo.GetTemplateContractFileReq;
import com.yunyinsign.api.sdk.model.vo.GetTemplateParticipantReq;
import com.yunyinsign.api.sdk.model.vo.SignFlowApprovalReq;
import com.yunyinsign.api.sdk.model.vo.TemplateCompSpecialAttrReq;
import com.yunyinsign.api.sdk.model.vo.TemplateComponentReq;
import com.yunyinsign.api.sdk.request.sign.ApprovalCancelReq;
import com.yunyinsign.api.sdk.request.sign.ApprovalInfoQueryReq;
import com.yunyinsign.api.sdk.request.sign.ApprovalQueryReq;
import com.yunyinsign.api.sdk.request.sign.ApprovalSignReq;
import com.yunyinsign.api.sdk.request.sign.BatchApprovalReq;
import com.yunyinsign.api.sdk.request.sign.GetApprovalSignUrlReq;
import com.yunyinsign.api.sdk.request.sign.GetDelSignFlowReq;
import com.yunyinsign.api.sdk.request.sign.GetDesignatedSignatureUrlReq;
import com.yunyinsign.api.sdk.request.sign.GetDirectComponentSignFlowReq;
import com.yunyinsign.api.sdk.request.sign.GetDownFilesReq;
import com.yunyinsign.api.sdk.request.sign.GetEnterpriseContractUrlReq;
import com.yunyinsign.api.sdk.request.sign.GetFetchSignerByShortCodeReq;
import com.yunyinsign.api.sdk.request.sign.GetFillUrlReq;
import com.yunyinsign.api.sdk.request.sign.GetMyActivitiesUrlReq;
import com.yunyinsign.api.sdk.request.sign.GetReversePayContractFeeReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowAttachmentFileReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowByMobileReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowCancelReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowComponentDetailQueryReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowComponentQueryReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowComponentSignQueryReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowContractFileReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowContractReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowCorpCountQueryReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowCorpExportReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowCorpInfoReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowCorpQueryReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowCountQueryReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowDetailQueryReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowExportReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowFillReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowIdReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowModifyRemarkReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowParticipantReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowQueryReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowRemindReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowSignReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowStrIdReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowTaskInfoReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowWishVerifyReq;
import com.yunyinsign.api.sdk.request.sign.GetSignUrlReq;
import com.yunyinsign.api.sdk.request.sign.GetSignerPayInfoReq;
import com.yunyinsign.api.sdk.request.sign.GetStartFlowTemplateReq;
import com.yunyinsign.api.sdk.request.sign.GetStartSignFlowReq;
import com.yunyinsign.api.sdk.request.sign.GetViewUrlReq;
import com.yunyinsign.api.sdk.request.sign.SignFlowApprovalVerifyReq;
import com.yunyinsign.api.sdk.response.sign.ApprovalCancelResponse;
import com.yunyinsign.api.sdk.response.sign.ApprovalInfoQueryResponse;
import com.yunyinsign.api.sdk.response.sign.ApprovalQueryResponse;
import com.yunyinsign.api.sdk.response.sign.ApprovalSignResponse;
import com.yunyinsign.api.sdk.response.sign.BatchApprovalResponse;
import com.yunyinsign.api.sdk.response.sign.GetApprovalSignUrlResponse;
import com.yunyinsign.api.sdk.response.sign.GetDesignatedSignatureUrlResponse;
import com.yunyinsign.api.sdk.response.sign.GetDirectComponentSignFlowResponse;
import com.yunyinsign.api.sdk.response.sign.GetEnterpriseContractUrlResponse;
import com.yunyinsign.api.sdk.response.sign.GetFetchSignerByShortCodeResponse;
import com.yunyinsign.api.sdk.response.sign.GetFillUrlResponse;
import com.yunyinsign.api.sdk.response.sign.GetMyActivitiesUrlResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowAttachmentFileResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowByMobileResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowComponentDetailQueryResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowComponentQueryResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowComponentSignQueryResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowContractFileResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowContractResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowCorpCountQueryResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowCorpInfoResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowCorpQueryResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowCountQueryResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowDetailQueryResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowFillResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowIdResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowParticipantResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowQueryResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowSignResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowStrIdResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowTaskInfoResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignUrlResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignerPayInfoResponse;
import com.yunyinsign.api.sdk.response.sign.GetStartFlowTemplateResponse;
import com.yunyinsign.api.sdk.response.sign.GetStartSignFlowResponse;
import com.yunyinsign.api.sdk.response.sign.GetViewUrlResponse;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author dyl
 * 企业管理相关接口
 */
public class SignApi {

    public static void main(String[] args) {
        // 1. 初始化客户端
        YunYinClient client = ClientConfig.initClient();
        SignApi signApi = new SignApi();
        //模板发起合同流程
        signApi.getStartSignFlowReq(client);

        //直接发起合同
        signApi.getStartFlowTemplateReq(client);

        //直接发起合同(指定签署位置处)
        signApi.getDirectComponentSignFlowReq(client);

        //获取指定签署位置直接发起合同链接
        signApi.getDesignatedSignatureUrlReq(client);

        //填写合同
        signApi.getSignFlowFillReq(client);

        //填写签署
        signApi.getSignFlowContractReq(client);

        //签署意愿验证
        signApi.getSignFlowWishVerifyReq(client);

        //对方付合同费用支付
        signApi.getReversePayContractFeeReq(client);

        //获取填写合同链接
        signApi.getFillUrlReq(client);

        //获取签署链接
        signApi.getSignUrlReq(client);

        //我的合同列表
        signApi.getSignFlowQueryReq(client);

        //我的合同数量
        signApi.getSignFlowCountQueryReq(client);

        //合同分页列表导出
        signApi.getSignFlowExportReq(client);

        //企业合同列表
        signApi.getSignFlowCorpQueryReq(client);

        //企业合同列表查询数量
        signApi.getSignFlowCorpCountQueryReq(client);

        //企业合同列表导出
        signApi.getSignFlowCorpExportReq(client);

        //根据手机号查询合同列表
        signApi.getSignFlowByMobileReq(client);

        //合同详情信息
        signApi.getSignFlowSignReq(client);

        //合同单条详情信息任务信息
        signApi.getSignFlowTaskInfoReq(client);

        //查询填写信息
        signApi.getSignFlowComponentQueryReq(client);

        //查询签名信息
        signApi.getSignFlowComponentSignQueryReq(client);

        //合同文档文件列表查询服务
        signApi.getSignFlowContractFileReq(client);

        //合同文档文件单条详情信息
        signApi.getSignFlowDetailQueryReq(client);

        //合同文件查询服务组件信息
        signApi.getSignFlowComponentDetailQueryReq(client);

        //分享链接查询合同封面(基本信息)
        signApi.getSignFlowStrIdReq(client);

        //根据短码查询合同参与方信息
        signApi.getFetchSignerByShortCodeReq(client);

        //合同附件文件信息查询
        signApi.getSignFlowAttachmentFileReq(client);

        //合同详细信息查询
        signApi.getSignFlowIdReq(client);

        //收款合同根据参与方查付款信息
        signApi.getSignerPayInfoReq(client);

        //文件下载
        signApi.getDownFilesReq(client);

        //我的合同页面链接
        signApi.getMyActivitiesUrlReq(client);

        //企业合同页面链接
        signApi.getEnterpriseContractUrlReq(client);

        //获取合同查看链接
        signApi.getViewUrlReq(client);

        //企业合同详情信息
        signApi.getSignFlowCorpInfoReq(client);

        //撤销合同
        signApi.getSignFlowCancelReq(client);

        //删除合同
        signApi.getDelSignFlowReq(client);

        //修改合同备注
        signApi.getSignFlowModifyRemarkReq(client);

        //流程催办
        signApi.getSignFlowRemindReq(client);

        //获取审批管理列表
        signApi.approvalQueryReq(client);

        //获取审批管理详情
        signApi.approvalInfoQueryReq(client);

        //审批合同用章
        signApi.approvalSignReq(client);

        //批量审批合同用章
        signApi.approvalReq(client);

        //撤销审批合同用章
        signApi.approvalCancelReq(client);

        //审批合同用章短信/密码认证回调方法
        signApi.signFlowApprovalVerifyReq(client);

        //获取合同用章审批链接
        signApi.getApprovalSignUrlReq(client);

        //根据合同参与方跳转小程序
        signApi.getSignFlowParticipantReq(client);
    }

    /*****************签署任务创建***********************/
    //模板发起合同流程
    private void getStartSignFlowReq(YunYinClient client) {
        GetStartSignFlowReq getStartSignFlowReq = new GetStartSignFlowReq();
        getStartSignFlowReq.setHeaderUserId(000000000L);
        getStartSignFlowReq.setTemplateId(1L);
        getStartSignFlowReq.setTemplateName("测试模板");
        getStartSignFlowReq.setAutoFill(0);
        List<GetStartSignFlowParticipantReq> participantList = new ArrayList<>();
        GetStartSignFlowParticipantReq participantReq = new GetStartSignFlowParticipantReq();
        participantReq.setParticipantFlag("签署方1");
        participantReq.setPsnAccount("13700000000");
        participantReq.setPsnName("张三");
        participantReq.setParticipantCorpName("测试公司");
        participantList.add(participantReq);
        GetStartSignFlowParticipantReq participantReq2 = new GetStartSignFlowParticipantReq();
        participantReq2.setParticipantFlag("签署方2");
        participantReq2.setPsnAccount("13700000001");
        participantReq2.setPsnName("李四");
        participantList.add(participantReq2);
        getStartSignFlowReq.setParticipantList(participantList);
        GetStartSignFlowResponse getStartSignFlowResponse = client.execute(getStartSignFlowReq);
        System.out.println(JSON.toJSONString(getStartSignFlowResponse.getData()));
    }

    //直接发起合同
    private void getStartFlowTemplateReq(YunYinClient client) {
        GetStartFlowTemplateReq getStartFlowTemplateReq = new GetStartFlowTemplateReq();
        getStartFlowTemplateReq.setHeaderUserId(000000000L);
        getStartFlowTemplateReq.setTemplateName("测试模板");
        List<GetTemplateParticipantReq> participantReqs = new ArrayList<>();
        GetTemplateParticipantReq participant = new GetTemplateParticipantReq();
        participant.setParticipantFlag("签署方1");
        participant.setPsnAccount("13700000000");
        participant.setPsnName("张三");
        participant.setParticipantCorpName("测试公司");
        participantReqs.add(participant);
        GetTemplateParticipantReq participant2 = new GetTemplateParticipantReq();
        participant2.setParticipantFlag("签署方2");
        participant2.setPsnAccount("13700000001");
        participant2.setPsnName("李四");
        participantReqs.add(participant2);
        getStartFlowTemplateReq.setParticipantList(participantReqs);

        List<GetTemplateContractFileReq> contractFileList = new ArrayList<>();
        GetTemplateContractFileReq getTemplateContractFileReq = new GetTemplateContractFileReq();
        getTemplateContractFileReq.setFileName("测试合同");
        getTemplateContractFileReq.setFileUrl("https://example.com/test.pdf");
        getTemplateContractFileReq.setTotalPage(1);
        getTemplateContractFileReq.setWidth(100);
        getTemplateContractFileReq.setHeight(100);
        contractFileList.add(getTemplateContractFileReq);
        getStartFlowTemplateReq.setContractFileList(contractFileList);

        GetTemplateComponentReq getTemplateComponentReq = new GetTemplateComponentReq();
        List<TemplateComponentReq> components = new ArrayList<>();
        TemplateComponentReq component = new TemplateComponentReq();
        component.setParticipantId(1L);
        component.setContractFileId(1L);
        component.setComponentName("签署方1");
        component.setComponentType(1);
        component.setRequired(1);
        component.setPositionX(BigDecimal.valueOf(100.0));
        component.setPositionY(BigDecimal.valueOf(100.0));
        component.setPageNum(1);
        components.add(component);
        getTemplateComponentReq.setComponents(components);
        getStartFlowTemplateReq.setComponent(getTemplateComponentReq);

        GetStartFlowTemplateResponse getStartFlowTemplateResponse = client.execute(getStartFlowTemplateReq);
        System.out.println(JSON.toJSONString(getStartFlowTemplateResponse.getData()));
    }

    //直接发起合同(指定签署位置处)
    private void getDirectComponentSignFlowReq(YunYinClient client) {
        GetDirectComponentSignFlowReq getDirectComponentSignFlowReq = new GetDirectComponentSignFlowReq();
        getDirectComponentSignFlowReq.setHeaderUserId(000000000L);
        getDirectComponentSignFlowReq.setTemplateId(1L);
        List<TemplateComponentReq> componentList = new ArrayList<>();
        TemplateComponentReq componentReq = new TemplateComponentReq();
        componentReq.setParticipantId(1L);
        componentReq.setContractFileId(1L);
        componentReq.setComponentName("签署方1");
        componentReq.setComponentType(1);
        componentReq.setRequired(1);
        componentReq.setPositionX(BigDecimal.valueOf(100.0));
        componentReq.setPositionY(BigDecimal.valueOf(100.0));
        componentReq.setPageNum(1);
        componentList.add(componentReq);
        getDirectComponentSignFlowReq.setComponents(componentList);
        GetDirectComponentSignFlowResponse getDirectComponentSignFlowResponse = client.execute(getDirectComponentSignFlowReq);
        System.out.println(JSON.toJSONString(getDirectComponentSignFlowResponse.getData()));
    }

    //获取指定签署位置直接发起合同链接
    private void getDesignatedSignatureUrlReq(YunYinClient client) {
        GetDesignatedSignatureUrlReq getDesignatedSignatureUrlReq = new GetDesignatedSignatureUrlReq();
        getDesignatedSignatureUrlReq.setHeaderUserId(000000000L);
        getDesignatedSignatureUrlReq.setFlowId(1L);
        GetDesignatedSignatureUrlResponse getDesignatedSignatureUrlResponse = client.execute(getDesignatedSignatureUrlReq);
        System.out.println(JSON.toJSONString(getDesignatedSignatureUrlResponse.getData()));
    }
    /*****************签署任务创建***********************/

    /*****************参与方签署***********************/
    //填写合同
    private void getSignFlowFillReq(YunYinClient client) {
        GetSignFlowFillReq getSignFlowFillReq = new GetSignFlowFillReq();
        getSignFlowFillReq.setHeaderUserId(000000000L);
        getSignFlowFillReq.setFlowId(1L);
        List<FillComponentCmd> fillComponentList = new ArrayList<>();
        FillComponentCmd fillComponent = new FillComponentCmd();
        fillComponent.setComponentId(1L);
        fillComponent.setParticipantId(1L);
        fillComponent.setContractFileId(1L);
        fillComponent.setValue("测试");
        fillComponentList.add(fillComponent);
        getSignFlowFillReq.setComponents(fillComponentList);
        GetSignFlowFillResponse getSignFlowFillResponse = client.execute(getSignFlowFillReq);
        System.out.println(JSON.toJSONString(getSignFlowFillResponse.getData()));
    }

    //填写签署
    private void getSignFlowContractReq(YunYinClient client) {
        GetSignFlowContractReq getSignFlowContractReq = new GetSignFlowContractReq();
        getSignFlowContractReq.setHeaderUserId(000000000L);
        getSignFlowContractReq.setFlowId(1L);
        List<SignComponentCmd> signComponentList = new ArrayList<>();
        SignComponentCmd signComponent = new SignComponentCmd();
        signComponent.setComponentId(1L);
        signComponent.setParticipantId(1L);
        signComponent.setContractFileId(1L);
        signComponent.setPageNum(1);
        signComponent.setPositionX(BigDecimal.valueOf(100.0));
        signComponent.setPositionY(BigDecimal.valueOf(100.0));
        signComponent.setFieldType(0);
        signComponent.setSealId(1L);
        TemplateCompSpecialAttrReq templateCompSpecialAttrReq = new TemplateCompSpecialAttrReq();
        templateCompSpecialAttrReq.setSealSpecs(1);
        templateCompSpecialAttrReq.setShowSignDate(1);
        signComponent.setSpecialAttribute(templateCompSpecialAttrReq);
        signComponentList.add(signComponent);
        getSignFlowContractReq.setComponents(signComponentList);
        GetSignFlowContractResponse getSignFlowContractResponse = client.execute(getSignFlowContractReq);
        System.out.println(JSON.toJSONString(getSignFlowContractResponse.getData()));
    }

    //签署意愿验证
    private void getSignFlowWishVerifyReq(YunYinClient client) {
        GetSignFlowWishVerifyReq getSignFlowWishVerifyReq = new GetSignFlowWishVerifyReq();
        getSignFlowWishVerifyReq.setHeaderUserId(000000000L);
        getSignFlowWishVerifyReq.setFlowId(1L);
        getSignFlowWishVerifyReq.setAuthType("SMS");
        getSignFlowWishVerifyReq.setVerifyCode("123456");
        client.execute(getSignFlowWishVerifyReq);
    }

    //对方付合同费用支付
    private void getReversePayContractFeeReq(YunYinClient client) {
        GetReversePayContractFeeReq getReversePayContractFeeReq = new GetReversePayContractFeeReq();
        getReversePayContractFeeReq.setHeaderUserId(000000000L);
        getReversePayContractFeeReq.setFlowId(1L);
        client.execute(getReversePayContractFeeReq);
    }

    //获取填写合同链接
    private void getFillUrlReq(YunYinClient client) {
        GetFillUrlReq getFillUrlReq = new GetFillUrlReq();
        getFillUrlReq.setHeaderUserId(000000000L);
        getFillUrlReq.setFlowId(1L);
        GetFillUrlResponse getFillUrlResponse = client.execute(getFillUrlReq);
        System.out.println(JSON.toJSONString(getFillUrlResponse.getData()));
    }

    //获取签署链接
    private void getSignUrlReq(YunYinClient client) {
        GetSignUrlReq getSignUrlReq = new GetSignUrlReq();
        getSignUrlReq.setHeaderUserId(000000000L);
        getSignUrlReq.setFlowId(1L);
        GetSignUrlResponse getSignUrlResponse = client.execute(getSignUrlReq);
        System.out.println(JSON.toJSONString(getSignUrlResponse.getData()));
    }
    /*****************参与方签署***********************/

    /*****************签署任务查询***********************/
    //我的合同列表
    private void getSignFlowQueryReq(YunYinClient client) {
        GetSignFlowQueryReq getSignFlowQueryReq = new GetSignFlowQueryReq();
        getSignFlowQueryReq.setHeaderUserId(000000000L);
        getSignFlowQueryReq.setListPageNo(1);
        getSignFlowQueryReq.setListPageSize(10);
        getSignFlowQueryReq.setDocQueryType(0);
        GetSignFlowQueryResponse getSignFlowQueryResponse = client.execute(getSignFlowQueryReq);
        System.out.println(JSON.toJSONString(getSignFlowQueryResponse.getData()));
    }

    //我的合同数量
    private void getSignFlowCountQueryReq(YunYinClient client) {
        GetSignFlowCountQueryReq getSignFlowCountQueryReq = new GetSignFlowCountQueryReq();
        getSignFlowCountQueryReq.setHeaderUserId(000000000L);
        getSignFlowCountQueryReq.setDocQueryType(0);
        GetSignFlowCountQueryResponse getSignFlowCountQueryResponse = client.execute(getSignFlowCountQueryReq);
        System.out.println(JSON.toJSONString(getSignFlowCountQueryResponse.getData()));
    }

    //合同分页列表导出
    private void getSignFlowExportReq(YunYinClient client) {
        GetSignFlowExportReq getSignFlowExportReq = new GetSignFlowExportReq();
        getSignFlowExportReq.setHeaderUserId(000000000L);
        getSignFlowExportReq.setListPageNo(1);
        getSignFlowExportReq.setListPageSize(10);
        getSignFlowExportReq.setDocQueryType(0);
        DownloadResponse downloadResponse = client.export(getSignFlowExportReq);
        System.out.println(JSON.toJSONString(downloadResponse.getFileBytes()));
    }

    //企业合同列表
    private void getSignFlowCorpQueryReq(YunYinClient client) {
        GetSignFlowCorpQueryReq getSignFlowCorpQueryReq = new GetSignFlowCorpQueryReq();
        getSignFlowCorpQueryReq.setHeaderUserId(000000000L);
        getSignFlowCorpQueryReq.setListPageNo(1);
        getSignFlowCorpQueryReq.setListPageSize(10);
        getSignFlowCorpQueryReq.setFlowStatus(3);
        GetSignFlowCorpQueryResponse getSignFlowCorpQueryResponse = client.execute(getSignFlowCorpQueryReq);
        System.out.println(JSON.toJSONString(getSignFlowCorpQueryResponse.getData()));
    }

    //企业合同列表查询数量
    private void getSignFlowCorpCountQueryReq(YunYinClient client) {
        GetSignFlowCorpCountQueryReq getSignFlowCorpCountQueryReq = new GetSignFlowCorpCountQueryReq();
        getSignFlowCorpCountQueryReq.setHeaderUserId(000000000L);
        getSignFlowCorpCountQueryReq.setFlowStatus(3);
        GetSignFlowCorpCountQueryResponse getSignFlowCorpCountQueryResponse = client.execute(getSignFlowCorpCountQueryReq);
        System.out.println(JSON.toJSONString(getSignFlowCorpCountQueryResponse.getData()));
    }

    //企业合同列表导出
    private void getSignFlowCorpExportReq(YunYinClient client) {
        GetSignFlowCorpExportReq getSignFlowCorpExportReq = new GetSignFlowCorpExportReq();
        getSignFlowCorpExportReq.setListPageNo(1);
        getSignFlowCorpExportReq.setListPageSize(10);
        DownloadResponse downloadResponse1 = client.export(getSignFlowCorpExportReq);
        System.out.println(JSON.toJSONString(downloadResponse1.getFileBytes()));
    }

    //根据手机号查询合同列表
    private void getSignFlowByMobileReq(YunYinClient client) {
        GetSignFlowByMobileReq getSignFlowByMobileReq = new GetSignFlowByMobileReq();
        getSignFlowByMobileReq.setHeaderUserId(000000000L);
        getSignFlowByMobileReq.setListPageNo(1);
        getSignFlowByMobileReq.setListPageSize(10);
        getSignFlowByMobileReq.setFlowStatus(3);
        getSignFlowByMobileReq.setMobile("13800000000");
        GetSignFlowByMobileResponse getSignFlowByMobileResponse = client.execute(getSignFlowByMobileReq);
        System.out.println(JSON.toJSONString(getSignFlowByMobileResponse.getData()));
    }

    //合同详情信息
    private void getSignFlowSignReq(YunYinClient client) {
        GetSignFlowSignReq getSignFlowSignReq = new GetSignFlowSignReq();
        getSignFlowSignReq.setHeaderUserId(000000000L);
        getSignFlowSignReq.setFlowId(1L);
        GetSignFlowSignResponse getSignFlowSignResponse = client.execute(getSignFlowSignReq);
        System.out.println(JSON.toJSONString(getSignFlowSignResponse.getData()));
    }

    //合同单条详情信息任务信息
    private void getSignFlowTaskInfoReq(YunYinClient client) {
        GetSignFlowTaskInfoReq getSignFlowTaskInfoReq = new GetSignFlowTaskInfoReq();
        getSignFlowTaskInfoReq.setHeaderUserId(000000000L);
        getSignFlowTaskInfoReq.setFlowId(1L);
        GetSignFlowTaskInfoResponse getSignFlowTaskInfoResponse = client.execute(getSignFlowTaskInfoReq);
        System.out.println(JSON.toJSONString(getSignFlowTaskInfoResponse.getData()));
    }

    //查询填写信息
    private void getSignFlowComponentQueryReq(YunYinClient client) {
        GetSignFlowComponentQueryReq getSignFlowComponentQueryReq = new GetSignFlowComponentQueryReq();
        getSignFlowComponentQueryReq.setHeaderUserId(000000000L);
        getSignFlowComponentQueryReq.setFlowId(1L);
        GetSignFlowComponentQueryResponse getSignFlowComponentQueryResponse = client.execute(getSignFlowComponentQueryReq);
        System.out.println(JSON.toJSONString(getSignFlowComponentQueryResponse.getData()));
    }

    //查询签名信息
    private void getSignFlowComponentSignQueryReq(YunYinClient client) {
        GetSignFlowComponentSignQueryReq getSignFlowComponentSignQueryReq = new GetSignFlowComponentSignQueryReq();
        getSignFlowComponentSignQueryReq.setHeaderUserId(000000000L);
        getSignFlowComponentSignQueryReq.setFlowId(1L);
        GetSignFlowComponentSignQueryResponse getSignFlowComponentSignQueryResponse = client.execute(getSignFlowComponentSignQueryReq);
        System.out.println(JSON.toJSONString(getSignFlowComponentSignQueryResponse.getData()));
    }

    //合同文档文件列表查询服务
    private void getSignFlowContractFileReq(YunYinClient client) {
        GetSignFlowContractFileReq getSignFlowContractFileReq = new GetSignFlowContractFileReq();
        getSignFlowContractFileReq.setHeaderUserId(000000000L);
        getSignFlowContractFileReq.setFlowId(1L);
        GetSignFlowContractFileResponse getSignFlowContractFileResponse = client.execute(getSignFlowContractFileReq);
        System.out.println(JSON.toJSONString(getSignFlowContractFileResponse.getData()));
    }

    //合同文档文件单条详情信息
    private void getSignFlowDetailQueryReq(YunYinClient client) {
        GetSignFlowDetailQueryReq getSignFlowDetailQueryReq = new GetSignFlowDetailQueryReq();
        getSignFlowDetailQueryReq.setHeaderUserId(000000000L);
        getSignFlowDetailQueryReq.setFileId(1L);
        GetSignFlowDetailQueryResponse getSignFlowDetailQueryResponse = client.execute(getSignFlowDetailQueryReq);
        System.out.println(JSON.toJSONString(getSignFlowDetailQueryResponse.getData()));
    }

    //合同文件查询服务组件信息
    private void getSignFlowComponentDetailQueryReq(YunYinClient client) {
        GetSignFlowComponentDetailQueryReq getSignFlowComponentDetailQueryReq = new GetSignFlowComponentDetailQueryReq();
        getSignFlowComponentDetailQueryReq.setHeaderUserId(000000000L);
        getSignFlowComponentDetailQueryReq.setFileId(1L);
        GetSignFlowComponentDetailQueryResponse getSignFlowComponentDetailQueryResponse = client.execute(getSignFlowComponentDetailQueryReq);
        System.out.println(JSON.toJSONString(getSignFlowComponentDetailQueryResponse.getData()));
    }

    //分享链接查询合同封面(基本信息)
    private void getSignFlowStrIdReq(YunYinClient client) {
        GetSignFlowStrIdReq getSignFlowStrIdReq = new GetSignFlowStrIdReq();
        getSignFlowStrIdReq.setHeaderUserId(000000000L);
        getSignFlowStrIdReq.setFlowId("1");
        GetSignFlowStrIdResponse getSignFlowStrIdResponse = client.execute(getSignFlowStrIdReq);
        System.out.println(JSON.toJSONString(getSignFlowStrIdResponse.getData()));
    }

    //根据短码查询合同参与方信息
    private void getFetchSignerByShortCodeReq(YunYinClient client) {
        GetFetchSignerByShortCodeReq getFetchSignerByShortCodeReq = new GetFetchSignerByShortCodeReq();
        getFetchSignerByShortCodeReq.setHeaderUserId(000000000L);
        getFetchSignerByShortCodeReq.setFlowId("SHORTCODE123ABC");
        GetFetchSignerByShortCodeResponse getFetchSignerByShortCodeResponse = client.execute(getFetchSignerByShortCodeReq);
        System.out.println(JSON.toJSONString(getFetchSignerByShortCodeResponse.getData()));
    }

    //合同附件文件信息查询
    private void getSignFlowAttachmentFileReq(YunYinClient client) {
        GetSignFlowAttachmentFileReq getSignFlowAttachmentFileReq = new GetSignFlowAttachmentFileReq();
        getSignFlowAttachmentFileReq.setHeaderUserId(000000000L);
        getSignFlowAttachmentFileReq.setAttachmentId(1L);
        GetSignFlowAttachmentFileResponse getSignFlowAttachmentFileResponse = client.execute(getSignFlowAttachmentFileReq);
        System.out.println(JSON.toJSONString(getSignFlowAttachmentFileResponse.getData()));
    }

    //合同详细信息查询
    private void getSignFlowIdReq(YunYinClient client) {
        GetSignFlowIdReq getSignFlowIdReq = new GetSignFlowIdReq();
        getSignFlowIdReq.setHeaderUserId(000000000L);
        getSignFlowIdReq.setFlowId(1L);
        GetSignFlowIdResponse getSignFlowIdResponse = client.execute(getSignFlowIdReq);
        System.out.println(JSON.toJSONString(getSignFlowIdResponse.getData()));
    }

    //收款合同根据参与方查付款信息
    private void getSignerPayInfoReq(YunYinClient client) {
        GetSignerPayInfoReq getSignerPayInfoReq = new GetSignerPayInfoReq();
        getSignerPayInfoReq.setHeaderUserId(000000000L);
        getSignerPayInfoReq.setFlowId(1L);
        GetSignerPayInfoResponse getSignerPayInfoResponse = client.execute(getSignerPayInfoReq);
        System.out.println(JSON.toJSONString(getSignerPayInfoResponse.getData()));
    }

    //文件下载
    private void getDownFilesReq(YunYinClient client) {
        GetDownFilesReq request = new GetDownFilesReq();
        request.setHeaderUserId(000000L);
        request.setHeaderSource("pc");
        request.setFileId(000000L);
        DownloadResponse response = client.download(request);
        System.out.println(response.getFileName());
    }

    //我的合同页面链接
    private void getMyActivitiesUrlReq(YunYinClient client) {
        GetMyActivitiesUrlReq getMyActivitiesUrlReq = new GetMyActivitiesUrlReq();
        getMyActivitiesUrlReq.setHeaderUserId(000000000L);
        GetMyActivitiesUrlResponse getMyActivitiesUrlResponse = client.execute(getMyActivitiesUrlReq);
        System.out.println(JSON.toJSONString(getMyActivitiesUrlResponse.getData()));
    }

    //企业合同页面链接
    private void getEnterpriseContractUrlReq(YunYinClient client) {
        GetEnterpriseContractUrlReq getEnterpriseContractUrlReq = new GetEnterpriseContractUrlReq();
        getEnterpriseContractUrlReq.setHeaderUserId(000000000L);
        GetEnterpriseContractUrlResponse getEnterpriseContractUrlResponse = client.execute(getEnterpriseContractUrlReq);
        System.out.println(JSON.toJSONString(getEnterpriseContractUrlResponse.getData()));
    }

    //获取合同查看链接
    private void getViewUrlReq(YunYinClient client) {
        GetViewUrlReq getViewUrlReq = new GetViewUrlReq();
        getViewUrlReq.setHeaderUserId(000000000L);
        GetViewUrlResponse getViewUrlResponse = client.execute(getViewUrlReq);
        System.out.println(JSON.toJSONString(getViewUrlResponse.getData()));
    }

    //企业合同详情信息
    private void getSignFlowCorpInfoReq(YunYinClient client) {
        GetSignFlowCorpInfoReq getSignFlowCorpInfoReq = new GetSignFlowCorpInfoReq();
        getSignFlowCorpInfoReq.setHeaderUserId(000000000L);
        getSignFlowCorpInfoReq.setFlowId(1L);
        GetSignFlowCorpInfoResponse getSignFlowCorpInfoResponse = client.execute(getSignFlowCorpInfoReq);
        System.out.println(JSON.toJSONString(getSignFlowCorpInfoResponse.getData()));
    }
    /*****************签署任务查询***********************/

    /*****************签署任务控制***********************/
    //撤销合同
    private void getSignFlowCancelReq(YunYinClient client) {
        GetSignFlowCancelReq getSignFlowCancelReq = new GetSignFlowCancelReq();
        getSignFlowCancelReq.setHeaderUserId(000000000L);
        getSignFlowCancelReq.setFlowId(1L);
        getSignFlowCancelReq.setCancelMsg("撤销合同");
        client.execute(getSignFlowCancelReq);
    }

    //删除合同
    private void getDelSignFlowReq(YunYinClient client) {
        GetDelSignFlowReq getDelSignFlowReq = new GetDelSignFlowReq();
        getDelSignFlowReq.setHeaderUserId(000000000L);
        getDelSignFlowReq.setFlowId(1L);
        client.execute(getDelSignFlowReq);
    }

    //修改合同备注
    private void getSignFlowModifyRemarkReq(YunYinClient client) {
        GetSignFlowModifyRemarkReq getSignFlowModifyRemarkReq = new GetSignFlowModifyRemarkReq();
        getSignFlowModifyRemarkReq.setHeaderUserId(000000000L);
        getSignFlowModifyRemarkReq.setFlowId(1L);
        getSignFlowModifyRemarkReq.setRemark("修改合同备注");
        client.execute(getSignFlowModifyRemarkReq);
    }

    //流程催办
    private void getSignFlowRemindReq(YunYinClient client) {
        GetSignFlowRemindReq getSignFlowRemindReq = new GetSignFlowRemindReq();
        getSignFlowRemindReq.setHeaderUserId(000000000L);
        getSignFlowRemindReq.setFlowId(1L);
        client.execute(getSignFlowRemindReq);
    }
    /*****************签署任务控制***********************/

    /*****************签署任务审批***********************/
    //获取审批管理列表
    private void approvalQueryReq(YunYinClient client) {
        ApprovalQueryReq approvalQueryReq = new ApprovalQueryReq();
        approvalQueryReq.setHeaderUserId(000000000L);
        approvalQueryReq.setListPageNo(1);
        approvalQueryReq.setListPageSize(10);
        approvalQueryReq.setDocQueryType(0);
        approvalQueryReq.setApprovalType(1);
        ApprovalQueryResponse approvalQueryResponse = client.execute(approvalQueryReq);
        System.out.println(JSON.toJSONString(approvalQueryResponse.getData()));
    }

    //获取审批管理详情
    private void approvalInfoQueryReq(YunYinClient client) {
        ApprovalInfoQueryReq approvalInfoQueryReq = new ApprovalInfoQueryReq();
        approvalInfoQueryReq.setHeaderUserId(000000000L);
        approvalInfoQueryReq.setApprovalId(1L);
        ApprovalInfoQueryResponse approvalInfoQueryResponse = client.execute(approvalInfoQueryReq);
        System.out.println(JSON.toJSONString(approvalInfoQueryResponse.getData()));
    }

    //审批合同用章
    private void approvalSignReq(YunYinClient client) {
        ApprovalSignReq approvalSignReq = new ApprovalSignReq();
        approvalSignReq.setHeaderUserId(000000000L);
        approvalSignReq.setApprovalId(1L);
        approvalSignReq.setApprovalStatus(1);
        ApprovalSignResponse approvalSignResponse = client.execute(approvalSignReq);
        System.out.println(JSON.toJSONString(approvalSignResponse.getData()));
    }

    //批量审批合同用章
    private void approvalReq(YunYinClient client) {
        SignFlowApprovalReq approvalReq = new SignFlowApprovalReq();
        approvalReq.setApprovalId(1463546747891528704L);
        approvalReq.setApprovalStatus(2);
        SignFlowApprovalReq approvalReq1 = new SignFlowApprovalReq();
        approvalReq1.setApprovalId(1462091648124095488L);
        approvalReq1.setApprovalStatus(2);
        List<SignFlowApprovalReq> approvalList = Arrays.asList(approvalReq, approvalReq1);
        BatchApprovalReq batchApprovalReq = new BatchApprovalReq();
        batchApprovalReq.setHeaderUserId(000000000L);
        batchApprovalReq.setHeaderSource("pc");
        batchApprovalReq.setListData(approvalList);
        BatchApprovalResponse batchApprovalResponse = client.execute(batchApprovalReq);
        System.out.println(JSON.toJSONString(batchApprovalResponse));
    }

    //撤销审批合同用章
    private void approvalCancelReq(YunYinClient client) {
        ApprovalCancelReq approvalCancelReq = new ApprovalCancelReq();
        approvalCancelReq.setHeaderUserId(000000000L);
        approvalCancelReq.setApprovalId(1L);
        approvalCancelReq.setApprovalStatus(4);
        approvalCancelReq.setFailReason("撤销");
        ApprovalCancelResponse approvalCancelResponse = client.execute(approvalCancelReq);
        System.out.println(JSON.toJSONString(approvalCancelResponse));
    }

    //审批合同用章短信/密码认证回调方法
    private void signFlowApprovalVerifyReq(YunYinClient client) {
        SignFlowApprovalVerifyReq signFlowApprovalVerifyReq = new SignFlowApprovalVerifyReq();
        signFlowApprovalVerifyReq.setHeaderUserId(000000000L);
        signFlowApprovalVerifyReq.setApprovalId("1");
        signFlowApprovalVerifyReq.setAuthType("sms");
        signFlowApprovalVerifyReq.setVerifyCode("123456");
        client.execute(signFlowApprovalVerifyReq);
    }

    //获取合同用章审批链接
    private void getApprovalSignUrlReq(YunYinClient client) {
        GetApprovalSignUrlReq getApprovalSignUrlReq = new GetApprovalSignUrlReq();
        getApprovalSignUrlReq.setHeaderUserId(000000000L);
        GetApprovalSignUrlResponse getApprovalSignUrlResponse = client.execute(getApprovalSignUrlReq);
        System.out.println(JSON.toJSONString(getApprovalSignUrlResponse.getData()));
    }

    /*****************签署任务审批***********************/
    //根据合同参与方跳转小程序
    private void getSignFlowParticipantReq(YunYinClient client) {
        GetSignFlowParticipantReq getSignFlowParticipantReq = new GetSignFlowParticipantReq();
        getSignFlowParticipantReq.setHeaderUserId(000000000L);
        getSignFlowParticipantReq.setParticipantId(1L);
        getSignFlowParticipantReq.setType(1);
        GetSignFlowParticipantResponse getSignFlowParticipantResponse = client.execute(getSignFlowParticipantReq);
        System.out.println(JSON.toJSONString(getSignFlowParticipantResponse.getData()));
    }

}
