package com.yunyinsign.api.demo;

import com.alibaba.fastjson.JSON;
import com.yunyinsign.api.sdk.client.YunYinClient;
import com.yunyinsign.api.sdk.request.seal.CorpPreViewReq;
import com.yunyinsign.api.sdk.request.seal.CreateSealAuthorReq;
import com.yunyinsign.api.sdk.request.seal.CreateSealByImageReq;
import com.yunyinsign.api.sdk.request.seal.CreateSealByTemplateReq;
import com.yunyinsign.api.sdk.request.seal.DeleteSealReq;
import com.yunyinsign.api.sdk.request.seal.GetModifySealReq;
import com.yunyinsign.api.sdk.request.seal.GetSealAuthorListReq;
import com.yunyinsign.api.sdk.request.seal.GetSealAuthorUrlReq;
import com.yunyinsign.api.sdk.request.seal.GetSealListReq;
import com.yunyinsign.api.sdk.request.seal.GetSealQueryReq;
import com.yunyinsign.api.sdk.request.seal.SealFilePreViewReq;
import com.yunyinsign.api.sdk.request.seal.UpdDefaultSealReq;
import com.yunyinsign.api.sdk.request.seal.UploadSealFileReq;
import com.yunyinsign.api.sdk.response.seal.CorpPreViewResponse;
import com.yunyinsign.api.sdk.response.seal.CreateSealByImageResponse;
import com.yunyinsign.api.sdk.response.seal.CreateSealByTemplateResponse;
import com.yunyinsign.api.sdk.response.seal.GetSealAuthorListResponse;
import com.yunyinsign.api.sdk.response.seal.GetSealAuthorUrlResponse;
import com.yunyinsign.api.sdk.response.seal.GetSealListResponse;
import com.yunyinsign.api.sdk.response.seal.GetSealQueryResponse;
import com.yunyinsign.api.sdk.response.seal.SealFilePreViewResponse;
import com.yunyinsign.api.sdk.response.seal.UploadSealFileResponse;

import java.util.ArrayList;
import java.util.List;

/**
 * @author dyl
 * 签章管理相关接口
 */
public class SealApi {

    public static void main(String[] args) {
        // 1. 初始化客户端
        YunYinClient client = ClientConfig.initClient();
        SealApi sealApi = new SealApi();
        // 创建模板印章
        sealApi.createSealByTemplateReq(client);

        // 创建图片印章
        sealApi.createSealByImageReq(client);
        // 上传印章图片文件
        sealApi.UploadSealFileReq(client);
        // 预览模板印章
        sealApi.corpPreViewReq(client);
        // 预览图片印章
        sealApi.sealFilePreViewReq(client);
        // 查询印章列表(分页)
        sealApi.getSealListReq(client);
        // 获取印章详情
        sealApi.getSealQueryReq(client);
        // 创建印章授权
        sealApi.createSealAuthorReq(client);
        // 获取印章授权列表
        sealApi.getSealAuthorListReq(client);
        // 删除印章
        sealApi.deleteSealReq(client);
        // 修改默认印章
        sealApi.updDefaultSealReq(client);
        // 修改印章名称
        sealApi.getModifySealReq(client);
        // 获取印章授权URL
        sealApi.getSealAuthorUrlReq(client);

    }

    private void createSealByTemplateReq(YunYinClient client) {
        CreateSealByTemplateReq createSealByTemplateReq = new CreateSealByTemplateReq();
        createSealByTemplateReq.setHeaderUserId(000000000L);
        createSealByTemplateReq.setSealName("市场部合同专用章");
        createSealByTemplateReq.setSealStyle(1);
        createSealByTemplateReq.setCategoryType("CONTRACT");
        createSealByTemplateReq.setSealTemplateStyle("round");
        createSealByTemplateReq.setSealColor("Red");
        CreateSealByTemplateResponse createSealByTemplateResponse = client.execute(createSealByTemplateReq);
        System.out.println(JSON.toJSONString(createSealByTemplateResponse.getData()));
    }

    //查询企业账户流水记录
    private void createSealByImageReq(YunYinClient client) {
        CreateSealByImageReq createSealByImageReq = new CreateSealByImageReq();
        createSealByImageReq.setHeaderUserId(000000000L);
        createSealByImageReq.setSealName("测试印章");
        createSealByImageReq.setSealStyle(3);
        createSealByImageReq.setCategoryType("OTHER");
        createSealByImageReq.setSealTemplateStyle("round");
        CreateSealByImageResponse createSealByImageResponse = client.execute(createSealByImageReq);
        System.out.println(JSON.toJSONString(createSealByImageResponse.getData()));
    }

    //上传印章图片文件
    private void UploadSealFileReq(YunYinClient client) {
        byte[] sealFileBytes = new byte[0];
        UploadSealFileReq request = UploadSealFileReq.create(sealFileBytes, "seal.png", "Red");
        request.setHeaderUserId(000000000L);
        UploadSealFileResponse uploadSealFileResponse = client.uploadFile(request);
        System.out.println(JSON.toJSONString(uploadSealFileResponse.getData()));
    }

    //预览模板印章
    private void corpPreViewReq(YunYinClient client) {
        CorpPreViewReq corpPreViewReq = new CorpPreViewReq();
        corpPreViewReq.setHeaderUserId(000000000L);
        corpPreViewReq.setSealName("市场部合同专用章");
        corpPreViewReq.setSealStyle(1);
        corpPreViewReq.setCategoryType("CONTRACT");
        corpPreViewReq.setSealTemplateStyle("round");
        corpPreViewReq.setSealColor("Red");
        CorpPreViewResponse corpPreViewResponse = client.execute(corpPreViewReq);
        System.out.println(JSON.toJSONString(corpPreViewResponse.getData()));
    }

    //预览图片印章
    private void sealFilePreViewReq(YunYinClient client) {
        SealFilePreViewReq sealFilePreViewReq = new SealFilePreViewReq();
        sealFilePreViewReq.setHeaderUserId(000000000L);
        sealFilePreViewReq.setFileName("seal.png");
        sealFilePreViewReq.setHttpUrl("https://yunyinsign.oss-cn-hangzhou.aliyuncs.com/seal/2020/05/07/20200507000000000000000000000001.png");
        sealFilePreViewReq.setSealColor("Red");
        SealFilePreViewResponse sealFilePreViewResponse = client.execute(sealFilePreViewReq);
        System.out.println(JSON.toJSONString(sealFilePreViewResponse.getData()));
    }

    //查询印章列表(分页)
    private void getSealListReq(YunYinClient client) {
        GetSealListReq getSealListReq = new GetSealListReq();
        getSealListReq.setHeaderUserId(000000000L);
        getSealListReq.setListPageNo(1);
        getSealListReq.setListPageNo(5);
        getSealListReq.setSealStatus(1);
        GetSealListResponse getSealListResponse = client.execute(getSealListReq);
        System.out.println(JSON.toJSONString(getSealListResponse.getData()));
    }


    //查询印章信息
    private void getSealQueryReq(YunYinClient client) {
        GetSealQueryReq getSealQueryReq = new GetSealQueryReq();
        getSealQueryReq.setHeaderUserId(000000000L);
        getSealQueryReq.setSealId(00000000000000000000000000000001L);
        GetSealQueryResponse getSealQueryResponse = client.execute(getSealQueryReq);
        System.out.println(JSON.toJSONString(getSealQueryResponse.getData()));
    }

    //新增印章授权
    private void createSealAuthorReq(YunYinClient client) {
        CreateSealAuthorReq createSealAuthorReq = new CreateSealAuthorReq();
        createSealAuthorReq.setHeaderUserId(000000000L);
        createSealAuthorReq.setSealId(00000000000000000000000000000001L);
        createSealAuthorReq.setAuthorMemberRange(1);
        List<CreateSealAuthorReq.UserInfo> userInfoList = new ArrayList<>();
        CreateSealAuthorReq.UserInfo userInfo = new CreateSealAuthorReq.UserInfo();
        userInfo.setUserId(000000000L);
        userInfoList.add(userInfo);
        createSealAuthorReq.setUserIdList(userInfoList);
        createSealAuthorReq.setAuthorRole("SEAL_USER");
        createSealAuthorReq.setAuthorRange(0);
        client.execute(createSealAuthorReq);
    }

    //查询印章授权列表
    private void getSealAuthorListReq(YunYinClient client) {
        GetSealAuthorListReq getSealAuthorListReq = new GetSealAuthorListReq();
        getSealAuthorListReq.setHeaderUserId(000000000L);
        getSealAuthorListReq.setSealId(00000000000000000000000000000001L);
        GetSealAuthorListResponse getSealAuthorListResponse = client.execute(getSealAuthorListReq);
        System.out.println(JSON.toJSONString(getSealAuthorListResponse.getData()));
    }

    //修改印章名称
    private void getModifySealReq(YunYinClient client) {
        GetModifySealReq getModifySealReq = new GetModifySealReq();
        getModifySealReq.setHeaderUserId(000000000L);
        getModifySealReq.setSealId(00000000000000000000000000000001L);
        getModifySealReq.setSealName("测试印章");
        client.execute(getModifySealReq);
    }

    //删除印章
    private void deleteSealReq(YunYinClient client) {
        DeleteSealReq deleteSealReq = new DeleteSealReq();
        deleteSealReq.setHeaderUserId(000000000L);
        deleteSealReq.setSealId(00000000000000000000000000000001L);
        client.execute(deleteSealReq);
    }

    //修改默认印章
    private void updDefaultSealReq(YunYinClient client) {
        UpdDefaultSealReq updDefaultSealReq = new UpdDefaultSealReq();
        updDefaultSealReq.setHeaderUserId(000000000L);
        updDefaultSealReq.setSealId(00000000000000000000000000000001L);
        client.execute(updDefaultSealReq);
    }

    //获取印章管理页面链接
    private void getSealAuthorUrlReq(YunYinClient client) {
        GetSealAuthorUrlReq getSealAuthorUrlReq = new GetSealAuthorUrlReq();
        getSealAuthorUrlReq.setHeaderUserId(000000000L);
        GetSealAuthorUrlResponse getSealAuthorUrlResponse = client.execute(getSealAuthorUrlReq);
        System.out.println(JSON.toJSONString(getSealAuthorUrlResponse.getData()));

    }

}
