package com.yunyinsign.api.demo;

import com.alibaba.fastjson.JSON;
import com.yunyinsign.api.sdk.client.YunYinClient;
import com.yunyinsign.api.sdk.request.pay.CancelPayOrderReq;
import com.yunyinsign.api.sdk.request.pay.GetPayChannelReq;
import com.yunyinsign.api.sdk.request.pay.GetPayOpenIdReq;
import com.yunyinsign.api.sdk.request.pay.GetPayOrderCreateReq;
import com.yunyinsign.api.sdk.request.pay.GetPayOrderListReq;
import com.yunyinsign.api.sdk.request.pay.GetPayOrderQueryReq;
import com.yunyinsign.api.sdk.request.pay.QueryCorpHasPayChannelReq;
import com.yunyinsign.api.sdk.response.pay.GetPayChannelResponse;
import com.yunyinsign.api.sdk.response.pay.GetPayOpenIdResponse;
import com.yunyinsign.api.sdk.response.pay.GetPayOrderCreateResponse;
import com.yunyinsign.api.sdk.response.pay.GetPayOrderListResponse;
import com.yunyinsign.api.sdk.response.pay.GetPayOrderQueryResponse;
import com.yunyinsign.api.sdk.response.pay.QueryCorpHasPayChannelResponse;

/**
 * @author dyl
 * 支付管理相关接口
 */
public class PayApi {

    public static void main(String[] args) {
        // 1. 查询企业是否配置了支付渠道
        YunYinClient client = ClientConfig.initClient();
        PayApi payApi = new PayApi();
        //查询企业是否配置了支付渠道
        payApi.queryCorpHasPayChannelReq(client);

        //2. 查询流程支付渠道列表
        payApi.getPayChannelReq(client);

        //3. 创建支付单
        payApi.getPayOrderCreateReq(client);

        //4. 支付单列表查询
        payApi.getPayOrderListReq(client);

        //5. 支付单查询
        payApi.getPayOrderQueryReq(client);
        //6. 支付单取消
        payApi.cancelPayOrderReq(client);

        //7. 获取OpenId
        payApi.getPayOpenIdReq(client);
    }

    private void queryCorpHasPayChannelReq(YunYinClient client){
        QueryCorpHasPayChannelReq queryCorpHasPayChannelReq = new QueryCorpHasPayChannelReq();
        queryCorpHasPayChannelReq.setHeaderUserId(000000000L);
        queryCorpHasPayChannelReq.setCorpId(000000000L);
        QueryCorpHasPayChannelResponse hasPayChannelResponse = client.execute(queryCorpHasPayChannelReq);
        System.out.println(hasPayChannelResponse.getData());
    }

    private void getPayChannelReq(YunYinClient client){
        GetPayChannelReq getPayChannelReq = new GetPayChannelReq();
        getPayChannelReq.setHeaderUserId(000000000L);
        getPayChannelReq.setFlowId(000000000L);
        getPayChannelReq.setSource("wx");
        GetPayChannelResponse getPayChannelResponse = client.execute(getPayChannelReq);
        System.out.println(JSON.toJSONString(getPayChannelResponse.getData()));
    }

    private void getPayOrderCreateReq(YunYinClient client){
        GetPayOrderCreateReq getPayOrderCreateReq = new GetPayOrderCreateReq();
        getPayOrderCreateReq.setHeaderUserId(000000000L);
        getPayOrderCreateReq.setChannelModelId(1L);
        getPayOrderCreateReq.setSignerId(8002L);
        getPayOrderCreateReq.setReturnUrl("https://your-website.com/payment/success");
        getPayOrderCreateReq.setSource("pc");
        GetPayOrderCreateResponse getPayOrderCreateResponse = client.execute(getPayOrderCreateReq);
        System.out.println(JSON.toJSONString(getPayOrderCreateResponse.getData()));
    }

    private void getPayOrderListReq(YunYinClient client){
        GetPayOrderListReq getPayOrderListReq = new GetPayOrderListReq();
        getPayOrderListReq.setHeaderUserId(000000000L);
        getPayOrderListReq.setListPageNo(1);
        getPayOrderListReq.setListPageSize(10);
        getPayOrderListReq.setStatus(2);
        GetPayOrderListResponse getPayOrderListResponse = client.execute(getPayOrderListReq);
        System.out.println(JSON.toJSONString(getPayOrderListResponse.getData()));
    }

    private void getPayOrderQueryReq(YunYinClient client){
        GetPayOrderQueryReq getPayOrderQueryReq = new GetPayOrderQueryReq();
        getPayOrderQueryReq.setHeaderUserId(000000000L);
        getPayOrderQueryReq.setId(000000000L);
        GetPayOrderQueryResponse getPayOrderQueryResponse = client.execute(getPayOrderQueryReq);
        System.out.println(JSON.toJSONString(getPayOrderQueryResponse.getData()));
    }

    private void cancelPayOrderReq(YunYinClient client){
        CancelPayOrderReq cancelPayOrderReq = new CancelPayOrderReq();
        cancelPayOrderReq.setHeaderUserId(000000000L);
        cancelPayOrderReq.setId(000000000L);
        client.execute(cancelPayOrderReq);
    }

    private void getPayOpenIdReq(YunYinClient client){
        GetPayOpenIdReq getPayOpenIdReq = new GetPayOpenIdReq();
        getPayOpenIdReq.setHeaderUserId(000000000L);
        getPayOpenIdReq.setChannelModelId(1L);
        getPayOpenIdReq.setAuthCode("xxxxxxxxxxxxxxxx");
        getPayOpenIdReq.setSource("wx");
        GetPayOpenIdResponse getPayOpenIdResponse = client.execute(getPayOpenIdReq);
        System.out.println(JSON.toJSONString(getPayOpenIdResponse.getData()));
    }

}
