package com.yunyinsign.api.demo;

import com.alibaba.fastjson.JSON;
import com.yunyinsign.api.sdk.client.YunYinClient;
import com.yunyinsign.api.sdk.request.fetch.GetFetchAuthUrlReq;
import com.yunyinsign.api.sdk.request.member.CreateMemberReq;
import com.yunyinsign.api.sdk.request.member.DeleteMemberReq;
import com.yunyinsign.api.sdk.request.member.FetchAuthReq;
import com.yunyinsign.api.sdk.request.member.GetPersonalAuthUrlReq;
import com.yunyinsign.api.sdk.request.member.MemberAccessAuthReq;
import com.yunyinsign.api.sdk.request.member.MemberAuthReq;
import com.yunyinsign.api.sdk.request.member.MemberInfoQueryReq;
import com.yunyinsign.api.sdk.request.member.MemberQueryReq;
import com.yunyinsign.api.sdk.response.fetch.GetFetchAuthUrlResponse;
import com.yunyinsign.api.sdk.response.member.CreateMemberResponse;
import com.yunyinsign.api.sdk.response.member.FetchAuthResponse;
import com.yunyinsign.api.sdk.response.member.GetPersonalAuthUrlResponse;
import com.yunyinsign.api.sdk.response.member.MemberAccessAuthResponse;
import com.yunyinsign.api.sdk.response.member.MemberInfoQueryResponse;
import com.yunyinsign.api.sdk.response.member.MemberQueryResponse;

/**
 * @author dyl
 * 人员与认证api相关接口
 */
public class MemberApi {

    public static void main(String[] args) {
        // 1. 初始化客户端
        YunYinClient client = ClientConfig.initClient();
        MemberApi memberApi = new MemberApi();

        //添加人员
        memberApi.memberReq(client);

        //查询企业成员信息
        memberApi.memberInfoQuery(client);

        //根据手机号/姓名查询
        memberApi.memberQueryReq(client);

        //个人认证更新
        memberApi.memberAuthReq(client);

        //获取个人实名链接
        memberApi.getPersonalAuthUrlReq(client);

        //获取人脸认证地址
        memberApi.fetchAuthReq(client);

        //公共方法获取个人/法人人脸认证地址
        memberApi.getFetchAuthUrlReq(client);

        //人员访问授权
        memberApi.memberAccessAuthReq(client);

        //删除人员
        memberApi.deleteMemberReq(client);

    }

    private void memberReq(YunYinClient client){
        CreateMemberReq memberReq = new CreateMemberReq();
        memberReq.setHeaderUserId(000000000L);
        memberReq.setUserName("张三");
        memberReq.setJobNum("000000000");
        memberReq.setMobile("13800000000");
        CreateMemberResponse memberResponse = client.execute(memberReq);
        System.out.println(JSON.toJSONString(memberResponse));
    }

    private void memberInfoQuery(YunYinClient client){
        MemberInfoQueryReq memberInfoQueryReq = new MemberInfoQueryReq();
        memberInfoQueryReq.setHeaderUserId(000000000L);
        memberInfoQueryReq.setMobile("xxxxxxx");
        MemberInfoQueryResponse memberInfoQueryResponse = client.execute(memberInfoQueryReq);
        System.out.println(JSON.toJSONString(memberInfoQueryResponse));
    }

    private void memberQueryReq(YunYinClient client){
        MemberQueryReq memberQueryReq = new MemberQueryReq();
        memberQueryReq.setHeaderUserId(000000000L);
        memberQueryReq.setParamString("xxxxxxx");
        MemberQueryResponse memberQueryResponse = client.execute(memberQueryReq);
        System.out.println(JSON.toJSONString(memberQueryResponse));
    }

    private void memberAuthReq(YunYinClient client){
        MemberAuthReq memberAuthReq = new MemberAuthReq();
        memberAuthReq.setHeaderUserId(000000000L);
        memberAuthReq.setRealName("张三");
        memberAuthReq.setIdentNum("XXXXXXXXXXXXXXXXXX");
        memberAuthReq.setSignPwd(123456);
        client.execute(memberAuthReq);
    }

    private void getPersonalAuthUrlReq(YunYinClient client){
        GetPersonalAuthUrlReq getPersonalAuthUrlReq = new GetPersonalAuthUrlReq();
        getPersonalAuthUrlReq.setHeaderUserId(000000000L);
        GetPersonalAuthUrlResponse getPersonalAuthUrlResponse = client.execute(getPersonalAuthUrlReq);
        System.out.println(getPersonalAuthUrlResponse.getData());
    }

    private void fetchAuthReq(YunYinClient client){
        FetchAuthReq fetchAuthReq = new FetchAuthReq();
        fetchAuthReq.setHeaderUserId(000000000L);
        FetchAuthResponse fetchAuthResponse = client.execute(fetchAuthReq);
        System.out.println(fetchAuthResponse.getData());
    }

    private void getFetchAuthUrlReq(YunYinClient client){
        GetFetchAuthUrlReq getFetchAuthUrlReq = new GetFetchAuthUrlReq();
        getFetchAuthUrlReq.setHeaderUserId(000000000L);
        getFetchAuthUrlReq.setId("000000000");
        getFetchAuthUrlReq.setAuthType("person");
        getFetchAuthUrlReq.setChannel("tencent");
        getFetchAuthUrlReq.setCallbackUrl("https://www.baidu.com");
        GetFetchAuthUrlResponse getFetchAuthUrlResponse = client.execute(getFetchAuthUrlReq);
        System.out.println(JSON.toJSONString(getFetchAuthUrlResponse.getData()));
    }

    private void memberAccessAuthReq(YunYinClient client){
        MemberAccessAuthReq memberAccessAuthReq = new MemberAccessAuthReq();
        memberAccessAuthReq.setHeaderUserId(000000000L);
        memberAccessAuthReq.setUserId(000000000L);
        MemberAccessAuthResponse memberAccessAuthResponse = client.execute(memberAccessAuthReq);
        System.out.println(memberAccessAuthResponse.getData());
    }

    private void deleteMemberReq(YunYinClient client){
        DeleteMemberReq deleteMemberReq = new DeleteMemberReq();
        deleteMemberReq.setHeaderUserId(000000000L);
        deleteMemberReq.setUserId(000000000L);
        client.execute(deleteMemberReq);
    }

}
