package com.yunyinsign.api.demo;

import com.yunyinsign.api.sdk.client.YunYinClient;
import com.yunyinsign.api.sdk.request.seal.UploadSealFileReq;
import com.yunyinsign.api.sdk.response.seal.UploadSealFileResponse;
import com.yunyinsign.api.sdk.result.GetFileUploadRes;
import com.yunyinsign.api.sdk.util.FileUtil;

import java.io.IOException;

/**
 * @author dyl
 */
public class GetUploadFileApi {

    public static void main(String[] args) throws IOException {
        // 1. 初始化客户端
        YunYinClient client = ClientConfig.initClient();
        byte[] sealFileBytes = FileUtil.readFileToBytes("test.png");
        UploadSealFileReq request = UploadSealFileReq.create(sealFileBytes, "seal.png","Red");
        request.setHeaderUserId(000000000L);
        request.setHeaderSource("pc");

        UploadSealFileResponse response = client.uploadFile(request);
        GetFileUploadRes res = response.getData();
        System.out.println(res.getFileName());
        System.out.println(res.getHttpUrl());
    }

}
