package com.yunyinsign.api.demo;

import com.alibaba.fastjson.JSON;
import com.yunyinsign.api.sdk.client.YunYinClient;
import com.yunyinsign.api.sdk.model.dto.SignComponentCmd;
import com.yunyinsign.api.sdk.model.vo.GetStartSignFlowParticipantReq;
import com.yunyinsign.api.sdk.model.vo.GetTemplateAttachmentReq;
import com.yunyinsign.api.sdk.model.vo.GetTemplatePayeeReq;
import com.yunyinsign.api.sdk.model.vo.TemplateCompSpecialAttrReq;
import com.yunyinsign.api.sdk.request.member.MemberInfoQueryReq;
import com.yunyinsign.api.sdk.request.pay.QueryCorpHasPayChannelReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowComponentSignQueryReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowContractReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowQueryReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowTaskInfoReq;
import com.yunyinsign.api.sdk.request.sign.GetSignFlowWishVerifyReq;
import com.yunyinsign.api.sdk.request.sign.GetStartSignFlowReq;
import com.yunyinsign.api.sdk.request.template.GetTemplateQueryReq;
import com.yunyinsign.api.sdk.request.template.TemplateInfoQueryReq;
import com.yunyinsign.api.sdk.response.member.MemberInfoQueryResponse;
import com.yunyinsign.api.sdk.response.pay.QueryCorpHasPayChannelResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowComponentSignQueryResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowContractResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowQueryResponse;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowTaskInfoResponse;
import com.yunyinsign.api.sdk.response.sign.GetStartSignFlowResponse;
import com.yunyinsign.api.sdk.response.template.GetTemplateQueryResponse;
import com.yunyinsign.api.sdk.response.template.TemplateInfoQueryResponse;
import com.yunyinsign.api.sdk.result.member.GetUserStatusRes;
import com.yunyinsign.api.sdk.result.sign.GetSignFlowComponentInfoRes;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @author dyl
 * 最小化流程发起合同
 */
public class DemoApi {

    public static void main(String[] args) {
        //1. 初始化客户端
        YunYinClient client = ClientConfig.initClient();
        DemoApi demo = new DemoApi();
        // 2. 获取操作者 userId
        demo.queryMemberInfo(client);
        // 4. 获取模板列表
        demo.queryTemplateList(client);
        // 5. 获取模板详情
        demo.queryTemplateInfo(client);
        // 6. 获取用户支付渠道
        demo.queryCorpHasPayChannel(client);
        // 7. 模板发起合同流程
        demo.startSignFlow(client);
        // 8. 查询合同列表
        demo.queryMyContractList(client);
        // 9. 查询签署流程任务信息
        demo.querySignFlowTaskInfo(client);
        // 10. 查询签名控件任务信息
        demo.querySignFlowComponentSignInfo(client);
        // 11.签署意愿验证
        demo.signWish(client);
        // 12. 签署合同
        demo.signFlowContract(client);

    }

    /**
     * 获取用户信息
     * @param client
     */
    public void queryMemberInfo(YunYinClient client){
        MemberInfoQueryReq request = new MemberInfoQueryReq();
        request.setMobile("xxxxxxx");
        MemberInfoQueryResponse response = client.execute(request);
        System.out.println(JSON.toJSONString(response));
        GetUserStatusRes userStatusRes = response.getData().get(0);
        System.out.println(userStatusRes.getUserId());
    }

    /**
     * 获取模板列表
     * @param client
     */
    public void queryTemplateList(YunYinClient client){
        GetTemplateQueryReq request = new GetTemplateQueryReq();
        request.setHeaderUserId(000000L);
        request.setTemplateStatus(1);
        request.setListPageNo(1);
        request.setListPageSize(10);
        GetTemplateQueryResponse response = client.execute(request);

        System.out.println(JSON.toJSONString(response));
    }

    /**
     * 获取模板详情
     * @param client
     */
    public void queryTemplateInfo(YunYinClient client){
        TemplateInfoQueryReq request = new TemplateInfoQueryReq();
        request.setHeaderUserId(000000L);
        request.setTemplateId(1463493320197049345L);
        request.setTemplateType("2");
        TemplateInfoQueryResponse response = client.execute(request);
        System.out.println(JSON.toJSONString(response));
        System.out.println(response.getData());
    }

    /**
     * 查询企业是否配置了支付渠道
     * @param client
     */
    public void queryCorpHasPayChannel(YunYinClient client){
        QueryCorpHasPayChannelReq request = new QueryCorpHasPayChannelReq();
        request.setHeaderUserId(000000L);
        request.setCorpId(1319673239881954304L);
        QueryCorpHasPayChannelResponse response = client.execute(request);
        System.out.println(response);
    }

    /**
     * 模板发起合同流程
     * @param client
     */
    public void startSignFlow(YunYinClient client){
        GetStartSignFlowReq request = new GetStartSignFlowReq();
        request.setHeaderUserId(000000L);

        //模板信息
        request.setTemplateId(1463493320197049345L);
        request.setTemplateCode("XXXXXX");  //指定模板. templateId、templateCode 可以二选一
        request.setTemplateName("先付后签");  //生成的合同名称
        request.setSourceOrderCode("20201201");//外部单号(企业app过来的可以保留一个外部来源单号)

        //参与方信息
        List<GetStartSignFlowParticipantReq> participantList = new ArrayList<>();
        //参与方1
        GetStartSignFlowParticipantReq participant1 = new GetStartSignFlowParticipantReq();
        participant1.setParticipantId(1463493320230603776L);
        participant1.setParticipantFlag("签署方1");//参与方标识，同一个模板中不可重复， 会展示到模板页面上，例如甲方、乙方等容易理解的业务名词（参与方ID和参与方标识二选一）
        participant1.setPsnAccount("xxxxxxx");  //签署人手机号
        participant1.setPsnName("杨凯");         //签收人姓名
        participant1.setParticipantCorpName("云银签测试用租户"); //参与方公司名称
        participant1.setPayeeContractFlag(0); //收款标识(0:普通合同；1：收款合同)
        participantList.add(participant1);
        //参与方2
        GetStartSignFlowParticipantReq participant2 = new GetStartSignFlowParticipantReq();
        participant2.setParticipantId(1463493320230603777L);
        participant2.setParticipantFlag("签署方2");
        participant2.setPsnAccount("13699840551");
        participant2.setPsnName("梁运和");
        participant2.setPayeeContractFlag(1);
        GetTemplatePayeeReq payee = new GetTemplatePayeeReq();  //收款信息。收款标识payeeContractFlag 设置为1时必须指定收款信息
        //payee.setId(1463493320230603777L);//收款信息ID. 修改填
        payee.setAmount(new BigDecimal(1));//收款金额
        payee.setPriority(0);//签署付款顺序(0：先付后签；1：先签后付)
        payee.setRemark("");//收款备注说明
        participant2.setPayee(payee);
        participantList.add(participant2);
        request.setParticipantList(participantList);

        //附件信息
        List<GetTemplateAttachmentReq> attachmentList = new ArrayList<>();
        request.setAttachmentList(attachmentList);

        //自动填写信息
//        request.setAutoFill(0);//自动填写标识（0：不自动填写；1：异步自动填写；2：同步自动填写），默认0
//        List<GetStartSignFlowComponentReq> fillComponents = new ArrayList<>();
//        GetStartSignFlowComponentReq fillComponent = new GetStartSignFlowComponentReq();
//        fillComponent.setComponentId(1463493320230603778L);//控件ID
//        fillComponent.setComponentKey("合同名称");//控件key，对应模板填写控件属性中设置的控件编码 或 控件名称 （控件ID和控件key二选一）
//        fillComponent.setComponentValue("测试合同");//控件填写的值
//        fillComponents.add(fillComponent);
//        request.setFillComponents(fillComponents);


        GetStartSignFlowResponse response = client.execute(request);
        System.out.println(JSON.toJSONString(response));
    }

    /**
     * 我的合同列表
     * @param client
     */
    public void queryMyContractList(YunYinClient client){
        GetSignFlowQueryReq request = new GetSignFlowQueryReq();
        request.setHeaderUserId(000000L);
        request.setDocQueryType(0);
        request.setListPageNo(1);
        request.setListPageSize(10);
        GetSignFlowQueryResponse response = client.execute(request);

        System.out.println(JSON.toJSONString(response));
    }

    /**
     * 合同单条详情信息任务信息
     * @param client
     */
    public void querySignFlowTaskInfo(YunYinClient client){
        GetSignFlowTaskInfoReq request = new GetSignFlowTaskInfoReq();
        request.setHeaderUserId(000000L);
        request.setFlowId(1463493320230603776L);
        GetSignFlowTaskInfoResponse response = client.execute(request);
        System.out.println(JSON.toJSONString(response));
    }

    /**
     * 查询签名信息
     * @param client
     */
    public void querySignFlowComponentSignInfo(YunYinClient client){
        GetSignFlowComponentSignQueryReq request = new GetSignFlowComponentSignQueryReq();
        request.setHeaderUserId(000000L);
        request.setFlowId(1463493320230603776L);
        GetSignFlowComponentSignQueryResponse response = client.execute(request);
        System.out.println(JSON.toJSONString(response));
        GetSignFlowComponentInfoRes signInfoRes = response.getData().get(0);
        System.out.println(JSON.toJSONString(signInfoRes));
    }

    /**
     * 签署意愿验证
     * @param client
     */
    public void signWish(YunYinClient client){
        GetSignFlowWishVerifyReq request = new GetSignFlowWishVerifyReq();
        request.setHeaderUserId(000000L);
        request.setFlowId(1463493320230603776L);
        request.setAuthType("pwd");//认证方式: sms:短信；pwd:密码； face:刷脸
        request.setNewPwd(false);
        request.setSignPwd("123456");

        client.execute(request);
    }

    /**
     * 填写签署
     * @param client
     */
    public void signFlowContract(YunYinClient client){
        GetSignFlowContractReq request = new GetSignFlowContractReq();
        request.setHeaderUserId(000000L);
        request.setFlowId(1463493320230603776L);
        List<SignComponentCmd> components = new ArrayList<>();
        SignComponentCmd component = new SignComponentCmd();
        component.setComponentId(1463493320230603778L);
        component.setParticipantId(1463493320230603776L);
        component.setContractFileId(1463493320230603779L);
        component.setFieldType(1);
        component.setPositionX(new BigDecimal(0));
        component.setPositionY(new BigDecimal(0));
        component.setPageNum(1);
        component.setSealId(1463493320230603777L);
        TemplateCompSpecialAttrReq specialAttribute = new TemplateCompSpecialAttrReq();
        specialAttribute.setSealSpecs(1);
        component.setSpecialAttribute(specialAttribute);
        components.add(component);
        request.setComponents(components);
        GetSignFlowContractResponse response = client.execute(request);
        System.out.println(JSON.toJSONString(response));
    }

}
