package com.yunyinsign.api.demo;

import com.alibaba.fastjson.JSON;
import com.yunyinsign.api.sdk.client.YunYinClient;
import com.yunyinsign.api.sdk.request.bill.GetSignFlowPayeeBillQueryReq;
import com.yunyinsign.api.sdk.request.bill.GetSignFlowPayeeBillRefundReq;
import com.yunyinsign.api.sdk.request.corp.BaseInfoReq;
import com.yunyinsign.api.sdk.request.corp.GetAccountHistoryQueryReq;
import com.yunyinsign.api.sdk.response.bill.GetSignFlowPayeeBillQueryResponse;
import com.yunyinsign.api.sdk.response.corp.BaseInfoResponse;
import com.yunyinsign.api.sdk.response.corp.GetAccountHistoryQueryResponse;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author dyl
 * 企业管理相关接口
 */
public class CorpApi {

    public static void main(String[] args) {
        // 1. 初始化客户端
        YunYinClient client = ClientConfig.initClient();

        CorpApi corpApi = new CorpApi();
        // 查询企业信息
        corpApi.baseInfoReq(client);

        //查询企业账户流水记录
        corpApi.getAccountHistoryQueryReq(client);

        //收款单查询 (主动对账)
        corpApi.getSignFlowPayeeBillQueryReq(client);

        //收款单发起退款
        corpApi.getSignFlowPayeeBillRefundReq(client);
    }

    private void baseInfoReq(YunYinClient client){
        BaseInfoReq baseInfoReq = new BaseInfoReq();
        baseInfoReq.setHeaderUserId(000000000L);
        BaseInfoResponse baseInfoResponse = client.execute(baseInfoReq);
        System.out.println(JSON.toJSONString(baseInfoResponse));
    }

    private void getAccountHistoryQueryReq(YunYinClient client){
        GetAccountHistoryQueryReq getAccountHistoryQueryReq = new GetAccountHistoryQueryReq();
        getAccountHistoryQueryReq.setHeaderUserId(000000000L);
        getAccountHistoryQueryReq.setListPageNo(1);
        getAccountHistoryQueryReq.setListPageSize(10);
        getAccountHistoryQueryReq.setRecordType("signContract");
        getAccountHistoryQueryReq.setBeginTime(LocalDateTime.now());
        GetAccountHistoryQueryResponse getAccountHistoryQueryResponse = client.execute(getAccountHistoryQueryReq);
        System.out.println(JSON.toJSONString(getAccountHistoryQueryResponse));
    }

    private void getSignFlowPayeeBillQueryReq(YunYinClient client){
        GetSignFlowPayeeBillQueryReq getSignFlowPayeeBillQueryReq = new GetSignFlowPayeeBillQueryReq();
        getSignFlowPayeeBillQueryReq.setHeaderUserId(000000000L);
        getSignFlowPayeeBillQueryReq.setListPageNo(1);
        getSignFlowPayeeBillQueryReq.setListPageSize(10);
        GetSignFlowPayeeBillQueryResponse getSignFlowPayeeBillQueryResponse = client.execute(getSignFlowPayeeBillQueryReq);
        System.out.println(JSON.toJSONString(getSignFlowPayeeBillQueryResponse));
    }

    private void getSignFlowPayeeBillRefundReq(YunYinClient client){
        GetSignFlowPayeeBillRefundReq getSignFlowPayeeBillRefundReq = new GetSignFlowPayeeBillRefundReq();
        getSignFlowPayeeBillRefundReq.setHeaderUserId(000000000L);
        getSignFlowPayeeBillRefundReq.setParticipateId(000000000L);
        getSignFlowPayeeBillRefundReq.setRefundAmount(new BigDecimal("100"));
        getSignFlowPayeeBillRefundReq.setRefundReason("测试");
        getSignFlowPayeeBillRefundReq.setSourceOrderCode("11111");
        client.execute(getSignFlowPayeeBillRefundReq);
    }

}
