# OP Java SDK 说明

# 简介

欢迎使用云银签开发者工具套件（SDK），OP Java SDK 是云银签 OP1.0 API在线文档的配套工具。


# 版本说明
目前版本 v1.0

## 快速开始

###一、springboot项目，引入sdk的starter依赖/引入jar包
1. 引入依赖
    ```xml
    <dependency>
        <groupId>com.yunyinsign.api</groupId>
        <artifactId>yunyin-op-sdk-java-v1.0</artifactId>
        <version>1.0-SNAPSHOT</version>
    </dependency>
    <dependency>                
        <groupId>commons-logging</groupId>
        <artifactId>commons-logging</artifactId>
        <version>1.2</version>
        <scope>compile</scope>
    </dependency>
    <dependency>
        <groupId>commons-codec</groupId>
        <artifactId>commons-codec</artifactId>
        <version>1.15</version>
    </dependency>
    ```

2. 使用demo
```
    //云银签OP1.0服务端地址
    private static String serverUrl = "https://openapi.yunyinsign.com";
    //云银签分配的appId
    private static final String appId = "xxxxxxxxxxx";
    //云银签分配的appId对应的秘钥
    private static final String appKey = "xxxxxxxxxxxxxxxxxxxxx";

    // 1. 初始化客户端
        YunYinClient client = new YunYinClient(appId, appSecret, serverUrl);
        BaseInfoReq request = new BaseInfoReq();
        request.setHeaderUserId(000000L);
        GetCorpBaseInfoRes response = client.execute(request, GetCorpBaseInfoRes.class);

        System.out.println(response.getCorpName());
    ```

## 最小化接口对接Demo

从api创建账户到签署完成的最小化流程,代码实现流程可查看SDK包内的com.yunyinsign.api.demo包下的com.yunyinsign.api.demo.Demo.java

# 模块说明

- SDK 以接口命名使用一对XXXReq和XXXRes实现接口快速调用<br>
  如查询企业基本信息详情接口， 接口地址为：/corp/baseInfo <br>
  SDK包内以request.corp包下会有一个BaseInfoResponse类<br>
  和response.corp包内的GetCorpBaseInfoRes类是相对应的<br>
  则初始化客户端后只需要使用com.yunyinsign.api.sdk.request.corp.BaseInfoReq创建一个request对象<br>
  使用client调用后会相对应的返回com.yunyinsign.api.sdk.response.corp.BaseInfoResponse对象
