/*
 * Decompiled with CFR 0.152.
 */
package com.yunyinsign.api.sdk.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.yunyinsign.api.sdk.core.BaseDownloadRequest;
import com.yunyinsign.api.sdk.core.BaseFileUploadRequest;
import com.yunyinsign.api.sdk.core.BaseListRequest;
import com.yunyinsign.api.sdk.core.BasePageRequest;
import com.yunyinsign.api.sdk.core.BaseRequest;

public class RequestTypeUtil {
    public static String buildRequestBody(BaseRequest<?> request) {
        if (request == null) {
            return "{}";
        }
        if (request instanceof BaseListRequest) {
            BaseListRequest listRequest = (BaseListRequest)request;
            return listRequest.toJson();
        }
        if (request instanceof BaseFileUploadRequest) {
            return "{}";
        }
        return JSON.toJSONString(request);
    }

    public static String buildRequestBody(BaseRequest<?> request, SerializerFeature ... features) {
        return JSON.toJSONString(request, (SerializerFeature[])features);
    }

    public static boolean isFileUploadRequest(BaseRequest<?> request) {
        return request instanceof BaseFileUploadRequest;
    }

    public static boolean isDownloadRequest(BaseRequest<?> request) {
        return request instanceof BaseDownloadRequest;
    }

    public static boolean isPageRequest(BaseRequest<?> request) {
        return request instanceof BasePageRequest;
    }

    public static boolean isListRequest(BaseRequest<?> request) {
        return request instanceof BaseListRequest;
    }

    public static String getApiPath(BaseRequest<?> request) {
        return request.getApiPath();
    }

    public static String getHttpMethod(BaseRequest<?> request) {
        return request.getHttpMethod();
    }

    public static String buildRequestHeaders(BaseRequest<?> request) {
        StringBuilder headers = new StringBuilder();
        if (request.getHeaderUserId() != null) {
            headers.append("userId: ").append(request.getHeaderUserId()).append("\n");
        }
        if (request.getHeaderSource() != null) {
            headers.append("source: ").append(request.getHeaderSource()).append("\n");
        }
        return headers.toString();
    }

    public static void validateRequest(BaseRequest<?> request) {
        if (request == null) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String apiPath = request.getApiPath();
        if (apiPath == null || apiPath.trim().isEmpty()) {
            throw new IllegalArgumentException("API\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String httpMethod = request.getHttpMethod();
        if (httpMethod == null || httpMethod.trim().isEmpty()) {
            throw new IllegalArgumentException("HTTP\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static String buildSpecialRequestBody(BaseRequest<?> request) {
        if (request instanceof BaseListRequest) {
            BaseListRequest listRequest = (BaseListRequest)request;
            return listRequest.toJson();
        }
        return JSON.toJSONString(request);
    }
}

