/*
 * Decompiled with CFR 0.152.
 */
package com.yunyinsign.api.sdk.util;

import com.alibaba.fastjson.JSON;
import com.yunyinsign.api.sdk.BaseObject;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpUtil {
    private static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
    private static final MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");

    public static <T extends BaseObject> T get(String url, Object params, Class<T> clazz) {
        try {
            HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
            if (params != null) {
                Map paramMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
                paramMap.forEach((k, v) -> {
                    if (v != null) {
                        urlBuilder.addQueryParameter(k, v.toString());
                    }
                });
            }
            Request request = new Request.Builder().url(urlBuilder.build()).get().build();
            Response response = client.newCall(request).execute();
            return (T)((BaseObject)JSON.parseObject((String)response.body().string(), clazz));
        }
        catch (IOException e) {
            throw new RuntimeException("HTTP request failed", e);
        }
    }

    public static <T extends BaseObject> T post(String url, Object params, Class<T> clazz) {
        try {
            RequestBody body = RequestBody.create((String)JSON.toJSONString((Object)params), (MediaType)JSON_TYPE);
            Request request = new Request.Builder().url(url).post(body).build();
            Response response = client.newCall(request).execute();
            return (T)((BaseObject)JSON.parseObject((String)response.body().string(), clazz));
        }
        catch (IOException e) {
            throw new RuntimeException("HTTP request failed", e);
        }
    }

    public static String get(String url, Object params) {
        try {
            HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
            if (params != null) {
                Map paramMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
                paramMap.forEach((k, v) -> {
                    if (v != null) {
                        urlBuilder.addQueryParameter(k, v.toString());
                    }
                });
            }
            Request request = new Request.Builder().url(urlBuilder.build()).get().build();
            Response response = client.newCall(request).execute();
            return response.body().string();
        }
        catch (IOException e) {
            throw new RuntimeException("HTTP request failed", e);
        }
    }

    public static String post(String url, Object params) {
        try {
            RequestBody body = RequestBody.create((String)JSON.toJSONString((Object)params), (MediaType)JSON_TYPE);
            Request request = new Request.Builder().url(url).post(body).build();
            Response response = client.newCall(request).execute();
            return response.body().string();
        }
        catch (IOException e) {
            throw new RuntimeException("HTTP request failed", e);
        }
    }
}

