/*
 * Decompiled with CFR 0.152.
 */
package com.yunyinsign.api.sdk.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;

public class FileUtil {
    public static byte[] readFileToBytes(String filePath) throws IOException {
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u5b58\u5728: " + filePath);
        }
        try (FileInputStream inputStream = new FileInputStream(file);){
            byte[] buffer = new byte[(int)file.length()];
            int bytesRead = ((InputStream)inputStream).read(buffer);
            if ((long)bytesRead != file.length()) {
                throw new IOException("\u6587\u4ef6\u8bfb\u53d6\u4e0d\u5b8c\u6574");
            }
            byte[] byArray = buffer;
            return byArray;
        }
    }

    public static byte[] readFileToBytesNIO(String filePath) throws IOException {
        return Files.readAllBytes(Paths.get(filePath, new String[0]));
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null || !fileName.contains(".")) {
            return "";
        }
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public static String getFileNameWithoutExtension(String fileName) {
        if (fileName == null) {
            return "";
        }
        int dotIndex = fileName.lastIndexOf(".");
        return dotIndex > 0 ? fileName.substring(0, dotIndex) : fileName;
    }

    public static boolean validateFileSize(byte[] fileBytes, int maxSizeMB) {
        if (fileBytes == null) {
            return false;
        }
        long maxBytes = (long)maxSizeMB * 1024L * 1024L;
        return (long)fileBytes.length <= maxBytes;
    }
}

