/*
 * Decompiled with CFR 0.152.
 */
package com.yunyinsign.api.sdk.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yunyinsign.api.sdk.result.OAuth2AccessToken;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class TokenManager {
    private final String appId;
    private final String appSecret;
    private final String baseUrl;
    private final OkHttpClient httpClient;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile TokenCache tokenCache;

    public TokenManager(String appId, String appSecret, String baseUrl) {
        this.appId = appId;
        this.appSecret = appSecret;
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
        this.httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    }

    public String getAccessToken() {
        if (this.tokenCache == null || !this.tokenCache.isValid()) {
            this.refreshToken();
        }
        return this.tokenCache.accessToken;
    }

    public Long getCorpId() {
        if (this.tokenCache == null || !this.tokenCache.isValid()) {
            this.refreshToken();
        }
        return this.tokenCache.corpId;
    }

    public String getAppId() {
        if (this.tokenCache == null || !this.tokenCache.isValid()) {
            this.refreshToken();
        }
        return this.appId;
    }

    private void refreshToken() {
        this.lock.lock();
        try {
            if (this.tokenCache == null || !this.tokenCache.isValid()) {
                OAuth2AccessToken token = this.fetchTokenFromServer();
                this.tokenCache = new TokenCache(token);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private OAuth2AccessToken fetchTokenFromServer() {
        try {
            String expiresInStr;
            String json = String.format("{\"appId\":\"%s\",\"appSecret\":\"%s\"}", this.appId, this.appSecret);
            RequestBody body = RequestBody.create((String)json, (MediaType)MediaType.parse((String)"application/json"));
            Request request = new Request.Builder().url(this.baseUrl + "/service/getAccessToken").post(body).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
            Response response = this.httpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new RuntimeException("\u83b7\u53d6Token\u5931\u8d25: " + response.code() + " - " + response.message());
            }
            String responseBody = response.body().string();
            JSONObject jsonObject = JSON.parseObject((String)responseBody);
            String code = jsonObject.getString("code");
            if (!"200".equals(code)) {
                String msg = jsonObject.getString("msg");
                throw new RuntimeException("\u83b7\u53d6Token\u5931\u8d25: " + code + " - " + msg);
            }
            JSONObject data = jsonObject.getJSONObject("data");
            if (data == null) {
                throw new RuntimeException("\u54cd\u5e94\u4e2d\u6ca1\u6709data\u5b57\u6bb5");
            }
            OAuth2AccessToken token = new OAuth2AccessToken();
            token.setAccessToken(data.getString("accessToken"));
            String corpIdStr = data.getString("corpId");
            if (corpIdStr != null) {
                try {
                    token.setCorpId(Long.parseLong(corpIdStr));
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("corpId\u683c\u5f0f\u9519\u8bef: " + corpIdStr);
                }
            }
            if ((expiresInStr = data.getString("expiresIn")) != null) {
                try {
                    long expiresIn = Long.parseLong(expiresInStr);
                    if (expiresIn > 100000L) {
                        token.setExpiresIn((int)(expiresIn / 1000L));
                    }
                    token.setExpiresIn((int)expiresIn);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("expiresIn\u683c\u5f0f\u9519\u8bef: " + expiresInStr);
                }
            } else {
                token.setExpiresIn(7200);
            }
            return token;
        }
        catch (IOException e) {
            throw new RuntimeException("\u83b7\u53d6Token\u7f51\u7edc\u5f02\u5e38: " + e.getMessage(), e);
        }
    }

    public void forceRefreshToken() {
        this.lock.lock();
        try {
            OAuth2AccessToken token = this.fetchTokenFromServer();
            this.tokenCache = new TokenCache(token);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearToken() {
        this.tokenCache = null;
    }

    private static class TokenCache {
        final String accessToken;
        final Long corpId;
        final long expireTime;

        TokenCache(OAuth2AccessToken token) {
            this.accessToken = token.getAccessToken();
            this.corpId = token.getCorpId();
            Integer expiresIn = token.getExpiresIn();
            if (expiresIn == null) {
                expiresIn = 7200;
            }
            if (expiresIn > 100000) {
                expiresIn = expiresIn / 1000;
            }
            long expiresMillis = TimeUnit.SECONDS.toMillis(token.getExpiresIn().intValue());
            this.expireTime = System.currentTimeMillis() + expiresMillis - TimeUnit.MINUTES.toMillis(5L);
        }

        boolean isValid() {
            return System.currentTimeMillis() < this.expireTime;
        }
    }
}

