/*
 * Decompiled with CFR 0.152.
 */
package com.yunyinsign.api.sdk.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.core.BaseResponse;
import java.util.List;

public abstract class BaseListRequest<T, R extends BaseResponse>
extends BaseRequest<R> {
    @JSONField(serialize=false)
    private List<T> listData;

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public List<T> getListData() {
        return this.listData;
    }

    public void setListData(List<T> listData) {
        this.listData = listData;
    }

    public String toJson() {
        if (this.listData == null || this.listData.isEmpty()) {
            return "[]";
        }
        return JSON.toJSONString(this.listData);
    }

    public static class Builder<T, R extends BaseResponse> {
        private final R request;
        private List<T> listData;

        public Builder(R request) {
            this.request = request;
        }

        public Builder<T, R> withListData(List<T> listData) {
            this.listData = listData;
            return this;
        }
    }
}

