/*
 * Decompiled with CFR 0.152.
 */
package com.yunyinsign.api.sdk.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yunyinsign.api.sdk.core.BaseDownloadRequest;
import com.yunyinsign.api.sdk.core.BaseFileUploadRequest;
import com.yunyinsign.api.sdk.core.BasePageResponse;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.core.DownloadResponse;
import com.yunyinsign.api.sdk.core.TokenManager;
import com.yunyinsign.api.sdk.util.RequestTypeUtil;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class YunYinClient {
    private final TokenManager tokenManager;
    private final OkHttpClient httpClient;
    private final String baseUrl;
    private final Long userId;

    public YunYinClient(String appId, String appSecret, String baseUrl) {
        this.tokenManager = new TokenManager(appId, appSecret, baseUrl);
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
        this.userId = null;
        this.httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    }

    public YunYinClient(String appId, String appSecret, String baseUrl, Long userId) {
        this.tokenManager = new TokenManager(appId, appSecret, baseUrl);
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
        this.userId = userId;
        this.httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    }

    public <R extends BaseResponse> R execute(BaseRequest<R> request) {
        return this.executeRequest(request, request.getResponseType());
    }

    public <R extends BaseResponse> R execute(BaseRequest<R> request, Long userId) {
        if (userId != null) {
            request.setHeaderUserId(userId);
        }
        return this.executeRequest(request, request.getResponseType());
    }

    public String executeRaw(BaseRequest<?> request) {
        try {
            Headers headers = this.buildHeaders(request);
            String jsonBody = RequestTypeUtil.buildRequestBody(request);
            Request httpRequest = this.buildRequest(request, headers, jsonBody);
            Response response = this.httpClient.newCall(httpRequest).execute();
            if (!response.isSuccessful()) {
                throw new RuntimeException("HTTP\u8bf7\u6c42\u5931\u8d25: " + response.code() + " - " + response.message());
            }
            ResponseBody body = response.body();
            if (body == null) {
                return "";
            }
            return body.string();
        }
        catch (IOException e) {
            throw new RuntimeException("API\u8c03\u7528\u5f02\u5e38", e);
        }
    }

    public <R extends BaseResponse> R uploadFile(BaseFileUploadRequest<R> request) {
        return this.uploadFile(request, request.getResponseType());
    }

    public <R extends BaseResponse> R uploadFile(BaseFileUploadRequest<R> request, Long userId) {
        if (userId != null) {
            request.setHeaderUserId(userId);
        }
        return this.uploadFile(request, request.getResponseType());
    }

    public DownloadResponse export(BaseDownloadRequest<?> request) {
        return this.downloadRequest(request);
    }

    public DownloadResponse export(BaseDownloadRequest<?> request, Long userId) {
        if (userId != null) {
            request.setHeaderUserId(userId);
        }
        return this.downloadRequest(request);
    }

    public DownloadResponse download(BaseDownloadRequest<?> request) {
        return this.downloadRequest(request);
    }

    public DownloadResponse download(BaseDownloadRequest<?> request, Long userId) {
        if (userId != null) {
            request.setHeaderUserId(userId);
        }
        return this.downloadRequest(request);
    }

    private <R extends BaseResponse> R uploadFile(BaseFileUploadRequest<R> request, Class<R> responseClass) {
        try (Response response = null;){
            String url = this.baseUrl + request.getApiPath();
            String accessToken = this.tokenManager.getAccessToken();
            String appId = this.tokenManager.getAppId();
            if (request.getFileBytes() == null || request.getFileBytes().length == 0) {
                throw new IllegalArgumentException("\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String fileName = request.getFileName();
            if (fileName == null || fileName.trim().isEmpty()) {
                throw new IllegalArgumentException("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            MultipartBody.Builder multipartBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            String fieldName = request.getFieldName();
            multipartBuilder.addFormDataPart(fieldName, fileName, RequestBody.create((byte[])request.getFileBytes(), (MediaType)MediaType.parse((String)"application/octet-stream")));
            Map<String, String> formParams = request.getFormParams();
            if (formParams != null && !formParams.isEmpty()) {
                for (Map.Entry<String, String> entry : formParams.entrySet()) {
                    multipartBuilder.addFormDataPart(entry.getKey(), entry.getValue());
                }
            }
            MultipartBody body = multipartBuilder.build();
            Headers.Builder headerBuilder = new Headers.Builder().add("accessToken", accessToken).add("source", "pc").add("userId", String.valueOf(this.userId)).add("appId", appId);
            if (request.getHeaderUserId() != null) {
                headerBuilder.add("userId", String.valueOf(request.getHeaderUserId()));
            }
            if (request.getHeaderSource() != null) {
                headerBuilder.add("source", request.getHeaderSource());
            }
            Headers headers = headerBuilder.build();
            Request httpRequest = new Request.Builder().url(url).headers(headers).post((RequestBody)body).build();
            response = this.httpClient.newCall(httpRequest).execute();
            if (!response.isSuccessful()) {
                String errorBody = response.body() != null ? response.body().string() : "";
                throw new RuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: " + response.code() + " - " + response.message() + "\n\u54cd\u5e94\u5185\u5bb9: " + errorBody);
            }
            String responseBody = response.body().string();
            JSONObject jsonObject = JSON.parseObject((String)responseBody);
            String code = jsonObject.getString("code");
            String msg = jsonObject.getString("msg");
            if (!"200".equals(code)) {
                throw new RuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: " + code + " - " + msg);
            }
            BaseResponse result = (BaseResponse)JSON.parseObject((String)responseBody, responseClass);
            result.setCode(code);
            result.setMsg(msg);
            BaseResponse baseResponse = result;
            return (R)baseResponse;
        }
    }

    public DownloadResponse downloadRequest(BaseDownloadRequest<?> request) {
        try (Response response = null;){
            Object responseBody;
            Headers headers = this.buildHeaders(request);
            String jsonBody = JSON.toJSONString(request);
            Request httpRequest = this.buildRequest(request, headers, jsonBody);
            response = this.httpClient.newCall(httpRequest).execute();
            if (!response.isSuccessful()) {
                throw new RuntimeException("\u4e0b\u8f7d\u5931\u8d25: " + response.code() + " - " + response.message());
            }
            String contentType = response.header("Content-Type", "");
            if (contentType.contains("application/json")) {
                responseBody = response.body().string();
                try {
                    JSONObject json = JSON.parseObject((String)responseBody);
                    String code = json.getString("code");
                    String msg = json.getString("msg");
                    if (!"200".equals(code)) {
                        throw new RuntimeException("\u4e0b\u8f7d\u5931\u8d25: " + code + " - " + msg);
                    }
                }
                catch (Exception json) {
                    // empty catch block
                }
            }
            if ((responseBody = response.body()) == null) {
                throw new RuntimeException("\u54cd\u5e94\u4f53\u4e3a\u7a7a");
            }
            byte[] fileBytes = responseBody.bytes();
            String fileName = this.extractFileName(response);
            String fileContentType = response.header("Content-Type", "application/octet-stream");
            DownloadResponse downloadResponse = new DownloadResponse(fileBytes, fileName, fileContentType);
            return downloadResponse;
        }
    }

    private <R extends BaseResponse> R executeRequest(BaseRequest<R> request, Class<R> responseClass) {
        try (Response httpResponse = null;){
            Headers headers = this.buildHeaders(request);
            String jsonBody = RequestTypeUtil.buildRequestBody(request);
            Request httpRequest = this.buildRequest(request, headers, jsonBody);
            httpResponse = this.httpClient.newCall(httpRequest).execute();
            if (!httpResponse.isSuccessful()) {
                throw new RuntimeException("HTTP\u8bf7\u6c42\u5931\u8d25: " + httpResponse.code() + " - " + httpResponse.message());
            }
            String responseBody = httpResponse.body().string();
            JSONObject jsonObject = JSON.parseObject((String)responseBody);
            String code = jsonObject.getString("code");
            String msg = jsonObject.getString("msg");
            if (!"200".equals(code)) {
                throw new RuntimeException("API\u8c03\u7528\u5931\u8d25: " + code + " - " + msg);
            }
            BaseResponse result = (BaseResponse)JSON.parseObject((String)responseBody, responseClass);
            result.setCode(code);
            result.setMsg(msg);
            if (result instanceof BasePageResponse) {
                BasePageResponse pageResponse = (BasePageResponse)result;
                pageResponse.setListPageNo(jsonObject.getInteger("listPageNo"));
                pageResponse.setCountInPage(jsonObject.getInteger("countInPage"));
                pageResponse.setListPageCount(jsonObject.getInteger("listPageCount"));
                pageResponse.setTotalCount(jsonObject.getInteger("totalCount"));
            }
            BaseResponse baseResponse = result;
            return (R)baseResponse;
        }
    }

    private String extractFileName(Response response) {
        Pattern pattern;
        Matcher matcher;
        String contentDisposition = response.header("Content-Disposition");
        if (contentDisposition != null && (matcher = (pattern = Pattern.compile("filename\\*?=\"?([^\";]+)")).matcher(contentDisposition)).find()) {
            String fileName = matcher.group(1);
            if (fileName.contains("%")) {
                try {
                    fileName = URLDecoder.decode(fileName, StandardCharsets.UTF_8.name());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return fileName;
        }
        return "download_file";
    }

    private Headers buildHeaders(BaseRequest<?> request) {
        String accessToken = this.tokenManager.getAccessToken();
        String appId = this.tokenManager.getAppId();
        Headers.Builder headerBuilder = new Headers.Builder().add("accessToken", accessToken).add("appId", appId).add("source", "pc").add("userId", String.valueOf(this.userId)).add("Content-Type", "application/json");
        if (request.getHeaderUserId() != null) {
            headerBuilder.add("userId", String.valueOf(request.getHeaderUserId()));
        }
        if (request.getHeaderSource() != null) {
            headerBuilder.add("source", request.getHeaderSource());
        }
        return headerBuilder.build();
    }

    private Request buildRequest(BaseRequest<?> request, Headers headers, String jsonBody) {
        RequestBody body = RequestBody.create((String)jsonBody, (MediaType)MediaType.parse((String)"application/json"));
        return new Request.Builder().url(this.baseUrl + request.getApiPath()).headers(headers).method(request.getHttpMethod(), body).build();
    }
}

